/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.style;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Variables;
import org.openvpms.web.echo.style.StyleSheetException;

public class StylePropertyEvaluator {
    private Map<String, String> defaults;
    private static final String FONT_SIZE = "font.size";
    private static final String FONT_H4_SIZE = "font.h4.size";
    private static final String PADDING_LARGE = "padding.large";
    private static final String PADDING_MEDIUM = "padding.medium";
    private static final String PADDING_SMALL = "padding.small";
    private static final String PADDING_SMALLER = "padding.smaller";
    private static final String PADDING_TINY = "padding.tiny";

    public StylePropertyEvaluator(Map<String, String> defaults) {
        this.setDefaultProperties(defaults);
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaults;
    }

    public void setDefaultProperties(Map<String, String> properties) {
        this.defaults = Collections.unmodifiableMap(properties);
    }

    public Map<String, String> getProperties(int width, int height) {
        return this.getProperties(width, height, null);
    }

    public Map<String, String> getProperties(int width, int height, Map<String, String> properties) {
        HashMap<String, String> result = new HashMap<String, String>(this.defaults);
        if (properties != null) {
            result.putAll(properties);
        }
        JXPathContext context = JXPathContext.newContext((Object)new Object());
        Variables variables = context.getVariables();
        variables.declareVariable("width", (Object)width);
        variables.declareVariable("height", (Object)height);
        this.evaluateAndDeclare(FONT_SIZE, result, context);
        this.evaluateAndDeclare(FONT_H4_SIZE, result, context);
        this.evaluateAndDeclare(PADDING_LARGE, result, context);
        this.evaluateAndDeclare(PADDING_MEDIUM, result, context);
        this.evaluateAndDeclare(PADDING_SMALL, result, context);
        this.evaluateAndDeclare(PADDING_SMALLER, result, context);
        this.evaluateAndDeclare(PADDING_TINY, result, context);
        this.evaluate(result, context);
        return result;
    }

    private void evaluate(Map<String, String> properties, JXPathContext context) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String name = entry.getKey();
            String expression = entry.getValue();
            if (expression == null) continue;
            String value = this.evaluate(expression, context);
            properties.put(name, value);
        }
    }

    private String evaluate(String expression, JXPathContext context) {
        String result = null;
        try {
            Object value = context.getValue(expression, Object.class);
            if (value instanceof Number) {
                result = String.valueOf(this.round((Number)value));
            } else if (value != null) {
                result = value.toString();
            }
        }
        catch (Throwable exception) {
            throw new StyleSheetException(StyleSheetException.ErrorCode.InvalidExpression, exception, expression);
        }
        return result;
    }

    private void evaluateAndDeclare(String name, Map<String, String> properties, JXPathContext context) {
        String expression = properties.get(name);
        if (expression != null) {
            String value = this.evaluate(expression, context);
            properties.put(name, value);
            context.getVariables().declareVariable(name, (Object)value);
        }
    }

    private long round(Number value) {
        if (value instanceof Integer || value instanceof Long) {
            return value.longValue();
        }
        BigDecimal result = value instanceof BigDecimal ? (BigDecimal)value : BigDecimal.valueOf(value.doubleValue());
        return result.setScale(0, RoundingMode.HALF_EVEN).longValue();
    }
}

