/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.list;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.ListBox;
import nextapp.echo2.app.list.AbstractListComponent;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import nextapp.echo2.app.list.ListSelectionModel;
import nextapp.echo2.app.list.StyledListCell;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.FocusSupport;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.servermessage.WindowUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import nextapp.echo2.webrender.util.DomUtil;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyListBoxPeer
implements ActionProcessor,
ComponentSynchronizePeer,
FocusSupport,
PropertyUpdateProcessor {
    private static final Service SERVICE;
    private static final String PROPERTY_SELECTION = "selection";
    private static final Color DEFAULT_BACKGROUND;
    private static final Color DEFAULT_FOREGROUND;
    private static final Extent DEFAULT_WIDTH;
    private static final Insets DEFAULT_INSETS;
    private static final String RENDERED_MODEL_MAP_KEY = "nextapp.echo2.webcontainer.syncpeer.ListComponentPeer.RenderedModelMap";
    private PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    private CssStyle createListComponentCssStyle(RenderContext rc, AbstractListComponent listComponent) {
        Color foreground;
        Font font;
        Border border;
        Color background;
        CssStyle cssStyle = new CssStyle();
        boolean renderEnabled = listComponent.isRenderEnabled();
        if (!renderEnabled) {
            background = (Color)listComponent.getRenderProperty("disabledBackground");
            border = (Border)listComponent.getRenderProperty("disabledBorder");
            font = (Font)listComponent.getRenderProperty("disabledFont");
            foreground = (Color)listComponent.getRenderProperty("disabledForeground");
            if (background == null) {
                background = (Color)listComponent.getRenderProperty("background", (Object)DEFAULT_BACKGROUND);
            }
            if (border == null) {
                border = (Border)listComponent.getRenderProperty("border");
            }
            if (font == null) {
                font = (Font)listComponent.getRenderProperty("font");
            }
            if (foreground == null) {
                foreground = (Color)listComponent.getRenderProperty("foreground", (Object)DEFAULT_FOREGROUND);
            }
        } else {
            border = (Border)listComponent.getRenderProperty("border");
            foreground = (Color)listComponent.getRenderProperty("foreground", (Object)DEFAULT_FOREGROUND);
            background = (Color)listComponent.getRenderProperty("background", (Object)DEFAULT_BACKGROUND);
            font = (Font)listComponent.getRenderProperty("font");
        }
        BorderRender.renderToStyle((CssStyle)cssStyle, (Border)border);
        ColorRender.renderToStyle((CssStyle)cssStyle, (Color)foreground, (Color)background);
        FontRender.renderToStyle((CssStyle)cssStyle, (Font)font);
        Extent width = (Extent)listComponent.getRenderProperty("width", (Object)DEFAULT_WIDTH);
        if (rc.getContainerInstance().getClientProperties().getBoolean("quirkIESelectPercentWidth") && width.getUnits() == 2) {
            width = null;
        }
        Extent height = (Extent)listComponent.getRenderProperty("height");
        Insets insets = (Insets)listComponent.getRenderProperty("insets", (Object)DEFAULT_INSETS);
        InsetsRender.renderToStyle((CssStyle)cssStyle, (String)"padding", (Insets)insets);
        ExtentRender.renderToStyle((CssStyle)cssStyle, (String)"width", (Extent)width);
        ExtentRender.renderToStyle((CssStyle)cssStyle, (String)"height", (Extent)height);
        cssStyle.setAttribute("position", "relative");
        return cssStyle;
    }

    private CssStyle createRolloverCssStyle(AbstractListComponent listComponent) {
        CssStyle style = new CssStyle();
        Color rolloverForeground = (Color)listComponent.getRenderProperty("rolloverForeground");
        Color rolloverBackground = (Color)listComponent.getRenderProperty("rolloverBackground");
        ColorRender.renderToStyle((CssStyle)style, (Color)rolloverForeground, (Color)rolloverBackground);
        FontRender.renderToStyle((CssStyle)style, (Font)((Font)listComponent.getRenderProperty("rolloverFont")));
        return style;
    }

    public String getContainerId(Component child) {
        throw new UnsupportedOperationException("Component does not support children.");
    }

    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, "action", null);
    }

    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String propertyName = propertyElement.getAttribute("name");
        if (PROPERTY_SELECTION.equals(propertyName)) {
            Element[] itemElements = DomUtil.getChildElementsByTagName((Element)propertyElement, (String)"item");
            int[] selectedIndices = new int[itemElements.length];
            for (int i = 0; i < itemElements.length; ++i) {
                selectedIndices[i] = Integer.parseInt(itemElements[i].getAttribute("index"));
            }
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "listSelectionChanged", (Object)selectedIndices);
        }
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(SERVICE.getId());
        AbstractListComponent listComponent = (AbstractListComponent)component;
        this.renderInitDirective(rc, listComponent, targetId);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(SERVICE.getId());
        this.renderDisposeDirective(rc, (AbstractListComponent)component);
    }

    private void renderDisposeDirective(RenderContext rc, AbstractListComponent listComponent) {
        String elementId = ContainerInstance.getElementId((Component)listComponent);
        ServerMessage serverMessage = rc.getServerMessage();
        Element initElement = serverMessage.appendPartDirective("preremove", "KeyListComponent.MessageProcessor", "dispose");
        initElement.setAttribute("eid", elementId);
    }

    private String renderContent(RenderContext rc, AbstractListComponent listComponent) {
        String contentId;
        RenderedModelData renderedModelData = new RenderedModelData(listComponent);
        HashMap<RenderedModelData, String> renderedModelDataToIdMap = (HashMap<RenderedModelData, String>)rc.getConnection().getProperty(RENDERED_MODEL_MAP_KEY);
        if (renderedModelDataToIdMap == null) {
            renderedModelDataToIdMap = new HashMap<RenderedModelData, String>();
            rc.getConnection().setProperty(RENDERED_MODEL_MAP_KEY, renderedModelDataToIdMap);
        }
        if ((contentId = (String)renderedModelDataToIdMap.get(renderedModelData)) == null) {
            contentId = Integer.toString(renderedModelDataToIdMap.size());
            renderedModelDataToIdMap.put(renderedModelData, contentId);
            this.renderLoadContentDirective(rc, renderedModelData, contentId);
        }
        return contentId;
    }

    private void renderLoadContentDirective(RenderContext rc, RenderedModelData renderedModelData, String contentId) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element partElement = serverMessage.appendPartDirective("init", "KeyListComponent.MessageProcessor", "load-content");
        partElement.setAttribute("content-id", contentId);
        Document document = serverMessage.getDocument();
        if (renderedModelData.styles != null) {
            partElement.setAttribute("styled", "true");
        }
        for (int i = 0; i < renderedModelData.values.length; ++i) {
            Element itemElement = document.createElement("item");
            itemElement.setAttribute("value", renderedModelData.values[i] == null ? "" : renderedModelData.values[i].toString());
            if (renderedModelData.styles != null) {
                itemElement.setAttribute("style", renderedModelData.styles[i] == null ? "" : renderedModelData.styles[i].toString());
            }
            partElement.appendChild(itemElement);
        }
    }

    private void renderInitDirective(RenderContext rc, AbstractListComponent listComponent, String targetId) {
        ListSelectionModel selectionModel;
        int minIndex;
        String contentId = this.renderContent(rc, listComponent);
        String elementId = ContainerInstance.getElementId((Component)listComponent);
        ServerMessage serverMessage = rc.getServerMessage();
        Document document = serverMessage.getDocument();
        Element initElement = serverMessage.appendPartDirective("update", "KeyListComponent.MessageProcessor", "init");
        initElement.setAttribute("container-eid", targetId);
        initElement.setAttribute("eid", elementId);
        initElement.setAttribute("content-id", contentId);
        initElement.setAttribute("enabled", listComponent.isRenderEnabled() ? "true" : "false");
        if (listComponent.hasActionListeners()) {
            initElement.setAttribute("server-notify", "true");
        }
        CssStyle cssStyle = this.createListComponentCssStyle(rc, listComponent);
        initElement.setAttribute("style", cssStyle.renderInline());
        Boolean rolloverEnabled = (Boolean)listComponent.getRenderProperty("rolloverEnabled");
        if (Boolean.TRUE.equals(rolloverEnabled)) {
            CssStyle rolloverCssStyle = this.createRolloverCssStyle(listComponent);
            initElement.setAttribute("rollover-style", rolloverCssStyle.renderInline());
        }
        boolean multipleSelect = false;
        if (listComponent instanceof ListBox) {
            initElement.setAttribute("type", "list-box");
            ListBox listBox = (ListBox)listComponent;
            if (listBox.getSelectionMode() == 2) {
                initElement.setAttribute("multiple", "true");
                multipleSelect = true;
            }
        }
        if (listComponent.isFocusTraversalParticipant()) {
            initElement.setAttribute("tab-index", Integer.toString(listComponent.getFocusTraversalIndex()));
        } else {
            initElement.setAttribute("tab-index", "-1");
        }
        String toolTipText = (String)listComponent.getRenderProperty("toolTipText");
        if (toolTipText != null) {
            initElement.setAttribute("tool-tip", toolTipText);
        }
        if ((minIndex = (selectionModel = listComponent.getSelectionModel()).getMinSelectedIndex()) >= 0) {
            if (multipleSelect) {
                Element selectionElement = document.createElement(PROPERTY_SELECTION);
                int maxIndex = selectionModel.getMaxSelectedIndex();
                for (int i = minIndex; i <= maxIndex; ++i) {
                    if (!selectionModel.isSelectedIndex(i)) continue;
                    Element itemElement = document.createElement("item");
                    itemElement.setAttribute("index", Integer.toString(i));
                    selectionElement.appendChild(itemElement);
                }
                initElement.appendChild(selectionElement);
            } else {
                initElement.setAttribute("selection-index", Integer.toString(minIndex));
            }
        }
    }

    public void renderSetFocus(RenderContext rc, Component component) {
        if (component.isEnabled()) {
            WindowUpdate.renderSetFocus((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId((Component)component));
        }
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        if (this.partialUpdateManager.canProcess(rc, update)) {
            this.partialUpdateManager.process(rc, update);
        } else {
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId((Component)update.getParent()));
            this.renderAdd(rc, update, targetId, update.getParent());
        }
        return true;
    }

    static {
        InputStream stream = KeyListBoxPeer.class.getResourceAsStream("/org/openvpms/web/echo/js/KeyList.js");
        try {
            String content = IOUtils.toString((InputStream)stream);
            SERVICE = new JavaScriptService("KeyListComponent", content);
            WebRenderServlet.getServiceRegistry().add(SERVICE);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        DEFAULT_BACKGROUND = Color.WHITE;
        DEFAULT_FOREGROUND = Color.BLACK;
        DEFAULT_WIDTH = new Extent(100, 2);
        DEFAULT_INSETS = new Insets(new Extent(0), new Extent(0));
    }

    private class RenderedModelData {
        private String[] values;
        private String[] styles;
        private int hashCode;

        private RenderedModelData(AbstractListComponent listComponent) {
            ListModel model = listComponent.getModel();
            ListCellRenderer renderer = listComponent.getCellRenderer();
            int size = model.size();
            this.values = new String[size];
            for (int i = 0; i < this.values.length; ++i) {
                Object renderedValue = renderer.getListCellRendererComponent((Component)listComponent, model.get(i), i);
                this.values[i] = renderedValue.toString();
                if (!(renderedValue instanceof StyledListCell)) continue;
                StyledListCell styledListCell = (StyledListCell)renderedValue;
                CssStyle itemStyle = new CssStyle();
                ColorRender.renderToStyle((CssStyle)itemStyle, (Color)styledListCell.getForeground(), (Color)styledListCell.getBackground());
                FontRender.renderToStyle((CssStyle)itemStyle, (Font)styledListCell.getFont());
                if (!itemStyle.hasAttributes()) continue;
                if (this.styles == null) {
                    this.styles = new String[size];
                }
                this.styles[i] = itemStyle.renderInline();
            }
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = this.values.length;
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.values[i] == null) continue;
                    this.hashCode ^= this.values[i].hashCode();
                }
                if (this.hashCode == 0) {
                    this.hashCode = 1;
                }
            }
            return this.hashCode;
        }

        public boolean equals(Object o) {
            int i;
            if (!(o instanceof RenderedModelData)) {
                return false;
            }
            RenderedModelData that = (RenderedModelData)o;
            if (this.values.length != that.values.length) {
                return false;
            }
            for (i = 0; i < this.values.length; ++i) {
                if (this.values[i] == that.values[i] || this.values[i] != null && this.values[i].equals(that.values[i])) continue;
                return false;
            }
            if (this.styles != null || that.styles != null) {
                if (this.styles == null || that.styles == null) {
                    return false;
                }
                for (i = 0; i < this.styles.length; ++i) {
                    if (this.styles[i] == that.styles[i] || this.styles[i] != null && this.styles[i].equals(that.styles[i])) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

