/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.focus;

import echopointng.DateField;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.DelegateFocusSupport;
import nextapp.echo2.app.TextField;
import org.openvpms.web.echo.focus.FocusHelper;

public class FocusGroup {
    private final String name;
    private FocusGroup parent;
    private boolean dirty = true;
    private List<Object> components = new ArrayList<Object>();
    private int first = -1;
    private int next = -1;
    private Component defaultFocus;

    public FocusGroup(String name) {
        this(name, -1);
    }

    public FocusGroup(String name, int first) {
        this.name = name;
        this.first = first;
    }

    public FocusGroup(String name, Component ... components) {
        this(name);
        for (Component component : components) {
            this.add(component);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setParent(FocusGroup group) {
        this.parent = group;
        this.setDirty(true);
    }

    public FocusGroup getParent() {
        return this.parent;
    }

    public void setDefault(Component component) {
        this.defaultFocus = component;
    }

    public Component getDefaultFocus() {
        return this.defaultFocus;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String toString() {
        return "[" + this.getFirst() + "," + this.getLast() + "] - " + this.getName();
    }

    public void add(Component component) {
        this.add(this.components.size(), component);
    }

    public void add(int index, Component component) {
        this.components.add(index, component);
        this.setDirty(true);
        this.reindex();
    }

    public void add(FocusGroup group) {
        this.add(this.components.size(), group);
    }

    public void add(int index, FocusGroup group) {
        this.components.add(index, group);
        group.setParent(this);
        this.setDirty(true);
        this.reindex();
    }

    public int indexOf(FocusGroup group) {
        return this.components.indexOf(group);
    }

    public void remove(FocusGroup group) {
        if (this.components.remove(group)) {
            group.setParent(null);
        }
    }

    public void remove(Component component) {
        this.components.remove(component);
    }

    public int size() {
        return this.components.size();
    }

    public List<Object> getComponents() {
        return this.components;
    }

    public int getFirst() {
        return this.first;
    }

    public int getLast() {
        return this.next != this.first ? this.next - 1 : this.first;
    }

    public void reindex() {
        int index = this.first <= 0 ? 1 : this.first;
        int last = this.getLast();
        this.reindex(index);
        if (last != this.getLast()) {
            this.notifyParent();
        }
    }

    public int reindex(int index) {
        if (this.first != index || this.isDirty()) {
            this.first = index;
            this.next = index;
            for (Object object : this.components) {
                if (object instanceof FocusGroup) {
                    FocusGroup group = (FocusGroup)object;
                    index = group.isDirty() || this.next > group.getFirst() ? group.reindex(this.next) : group.getLast();
                    this.next = index + 1;
                    continue;
                }
                Component component = (Component)object;
                this.setIndex(component, ++this.next);
            }
            index = this.next;
            this.setDirty(false);
        } else {
            index = this.getLast();
        }
        return index;
    }

    public Component getFocusable() {
        Object object;
        Component result = null;
        Iterator<Object> iterator = this.getComponents().iterator();
        while (iterator.hasNext() && (result = (object = iterator.next()) instanceof Component ? FocusHelper.getFocusable((Component)object) : ((FocusGroup)object).getFocusable()) == null) {
        }
        return result;
    }

    public void setFocus() {
        Component focus = this.defaultFocus != null ? this.defaultFocus : this.getFocusable();
        FocusHelper.setFocus(focus);
    }

    public boolean hasFocus() {
        Component focus = FocusHelper.getFocus();
        return focus != null && this.hasFocus(focus);
    }

    public void print(PrintStream stream) {
        for (Object component : this.components) {
            if (!(component instanceof FocusGroup)) continue;
            this.dump((FocusGroup)component, 0, stream);
        }
    }

    protected void dump(FocusGroup group, int depth, PrintStream stream) {
        for (int i = 0; i < depth; ++i) {
            stream.print(".");
        }
        stream.println(group);
        for (Object child : group.components) {
            if (!(child instanceof FocusGroup)) continue;
            this.dump((FocusGroup)child, depth + 1, stream);
        }
    }

    protected void notifyParent() {
        if (this.parent != null) {
            this.parent.setDirty(true);
            this.parent.reindex();
        }
    }

    private boolean hasFocus(Component focus) {
        for (Object object : this.components) {
            FocusGroup group;
            if (!(object instanceof Component ? object == focus : (group = (FocusGroup)object).hasFocus(focus))) continue;
            return true;
        }
        return false;
    }

    private void setIndex(Component component, int index) {
        if (component instanceof DelegateFocusSupport) {
            component = ((DelegateFocusSupport)component).getFocusComponent();
        }
        component.setFocusTraversalIndex(index);
        if (component instanceof DateField) {
            TextField text = ((DateField)component).getTextField();
            text.setFocusTraversalIndex(index);
        }
    }
}

