/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.factory;

import echopointng.ButtonEx;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.MutableStyle;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.button.ButtonGroup;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.web.echo.button.ShortcutButton;
import org.openvpms.web.echo.button.ShortcutHelper;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ComponentFactory;
import org.openvpms.web.resource.i18n.Messages;

public final class ButtonFactory
extends ComponentFactory {
    private static final String TYPE = "button";

    public static Button create() {
        ButtonEx button = new ButtonEx();
        ButtonFactory.setDefaultStyle((Component)button);
        return button;
    }

    public static Button create(String key) {
        return ButtonFactory.create(key, true);
    }

    public static Button create(String key, boolean enableShortcuts) {
        ShortcutButton button;
        ShortcutButton shortcutButton = button = enableShortcuts ? new ShortcutButton() : new ButtonEx();
        if (key != null) {
            String text = ButtonFactory.getString(TYPE, key, false);
            if (!enableShortcuts) {
                text = ShortcutHelper.getText(text);
            }
            button.setText(text);
            button.setId(key);
            button.setActionCommand(key);
        }
        ButtonFactory.setDefaultStyle((Component)button);
        return button;
    }

    public static Button create(final Runnable listener) {
        return ButtonFactory.create(new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                listener.run();
            }
        });
    }

    public static Button create(nextapp.echo2.app.event.ActionListener listener) {
        Button button = ButtonFactory.create();
        button.addActionListener(listener);
        return button;
    }

    public static Button create(String key, final Runnable listener) {
        return ButtonFactory.create(key, new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                listener.run();
            }
        });
    }

    public static Button create(String key, nextapp.echo2.app.event.ActionListener listener) {
        Button button = ButtonFactory.create(key);
        button.addActionListener(listener);
        return button;
    }

    public static Button create(String key, String style) {
        return ButtonFactory.create(key, style, true);
    }

    public static Button create(String key, String style, boolean enableShortcuts) {
        Button button = ButtonFactory.create(key, enableShortcuts);
        ButtonFactory.setStyle((Component)button, style);
        return button;
    }

    public static Button create(String key, String style, final Runnable listener) {
        return ButtonFactory.create(key, style, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                listener.run();
            }
        });
    }

    public static Button create(String key, String style, nextapp.echo2.app.event.ActionListener listener) {
        return ButtonFactory.create(key, style, true, listener);
    }

    public static Button create(String key, String style, boolean enableShortcuts, final Runnable listener) {
        return ButtonFactory.create(key, style, enableShortcuts, new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                listener.run();
            }
        });
    }

    public static Button create(String key, String style, boolean enableShortcuts, nextapp.echo2.app.event.ActionListener listener) {
        Button button = ButtonFactory.create(key, style, enableShortcuts);
        button.addActionListener(listener);
        return button;
    }

    public static RadioButton create(String key, ButtonGroup group) {
        String label = key != null ? Messages.get((String)key) : null;
        RadioButton button = new RadioButton(label);
        button.setGroup(group);
        ButtonFactory.setDefaultStyle((Component)button);
        return button;
    }

    public static RadioButton create(String key, ButtonGroup group, final Runnable listener) {
        return ButtonFactory.create(key, group, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                listener.run();
            }
        });
    }

    public static RadioButton create(String key, ButtonGroup group, nextapp.echo2.app.event.ActionListener listener) {
        RadioButton button = ButtonFactory.create(key, group);
        button.addActionListener(listener);
        return button;
    }

    public static Button text(String text, final Runnable listener) {
        return ButtonFactory.text(text, new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                listener.run();
            }
        });
    }

    public static Button text(String text, nextapp.echo2.app.event.ActionListener listener) {
        Button button = ButtonFactory.create(listener);
        button.setText(text);
        return button;
    }

    public static RadioButton text(String text, ButtonGroup group, final Runnable listener) {
        return ButtonFactory.text(text, group, new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                listener.run();
            }
        });
    }

    public static RadioButton text(String text, ButtonGroup group, nextapp.echo2.app.event.ActionListener listener) {
        RadioButton button = ButtonFactory.text(text, group);
        button.addActionListener(listener);
        return button;
    }

    public static RadioButton text(String text, ButtonGroup group) {
        RadioButton button = ButtonFactory.create(null, group);
        button.setText(text);
        return button;
    }

    static {
        MutableStyle defaultStyle = (MutableStyle)ButtonEx.DEFAULT_STYLE;
        defaultStyle.removeProperty("background");
        defaultStyle.removeProperty("rolloverBackground");
        defaultStyle.removeProperty("disabledForeground");
    }
}

