/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.colour;

import nextapp.echo2.app.Color;

public class ColourHelper {
    public static String getString(Color value) {
        if (value != null) {
            return "0x" + Integer.toHexString(value.getRgb());
        }
        return null;
    }

    public static Color getColor(String value) {
        if (value != null) {
            try {
                int rgb = Integer.decode(value);
                return new Color(rgb);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Color getTextColour(Color colour) {
        int distToWhite;
        int distToBlack = ColourHelper.distance(colour, Color.BLACK);
        return distToBlack < (distToWhite = ColourHelper.distance(colour, Color.WHITE)) ? Color.WHITE : Color.BLACK;
    }

    private static int distance(Color colour1, Color colour2) {
        return ColourHelper.square(30 * (colour1.getRed() - colour2.getRed())) + ColourHelper.square(59 * (colour1.getGreen() - colour2.getGreen())) + ColourHelper.square(11 * (colour1.getBlue() - colour2.getBlue()));
    }

    private static int square(int value) {
        return value * value;
    }
}

