/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.util;

import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.Objects;

public class DoubleClickMonitor {
    private SoftReference<Object> last;
    private Date lastClick;
    private final int interval;

    public DoubleClickMonitor() {
        this(0);
    }

    public DoubleClickMonitor(int interval) {
        this.interval = interval;
    }

    public boolean isDoubleClick(Object object) {
        Date now = new Date();
        boolean result = this.lastClick != null && (this.interval == 0 || this.lastClick.getTime() + (long)this.interval >= now.getTime());
        Object old = this.last != null ? this.last.get() : null;
        boolean bl = result = result && Objects.equals(old, object);
        if (result) {
            this.reset();
        } else {
            this.lastClick = now;
            this.last = new SoftReference<Object>(object);
        }
        return result;
    }

    public void reset() {
        this.lastClick = null;
        this.last = null;
    }

    public boolean isDoubleClick() {
        return this.isDoubleClick(null);
    }
}

