/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.text;

import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.text.TextArea;

public class TitledTextArea
extends Column {
    private TextArea textArea;
    private int minHeight = 6;
    private int maxHeight = 15;
    public static final int MIN_HEIGHT = 6;
    private static final int MAX_HEIGHT = 15;

    public TitledTextArea(String title) {
        this.setStyleName("CellSpacing");
        this.textArea = TextComponentFactory.createTextArea();
        this.textArea.setWidth(new Extent(100, 2));
        this.textArea.setStyleName("edit");
        Label label = LabelFactory.create();
        label.setText(title);
        this.add((Component)label);
        this.add((Component)this.textArea);
    }

    public void setEnabled(boolean newValue) {
        this.textArea.setEnabled(newValue);
    }

    public void setText(String text) {
        this.textArea.setText(text);
        this.textArea.setHeight(new Extent(this.getLinesToDisplay(text), 64));
    }

    protected int getLinesToDisplay(String text) {
        int lines = this.minHeight;
        if (text != null) {
            lines = StringUtils.countMatches((CharSequence)text, (CharSequence)"\n");
            if (lines > this.maxHeight) {
                lines = this.maxHeight;
            } else if (lines < this.minHeight) {
                lines = this.minHeight;
            }
        }
        return lines;
    }
}

