/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.table;

import java.io.Serializable;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.TableModelListener;
import nextapp.echo2.app.list.DefaultListModel;
import nextapp.echo2.app.list.DefaultListSelectionModel;
import nextapp.echo2.app.list.ListModel;
import nextapp.echo2.app.list.ListSelectionModel;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.table.PageableTableModel;
import org.openvpms.web.resource.i18n.Messages;

public class TableNavigator
extends Row {
    private final Table table;
    private Button first;
    private Button previous;
    private Button next;
    private Button last;
    private SelectField pageSelector;
    private Label pageCount;

    public TableNavigator(Table table) {
        this.table = table;
        this.table.getModel().addTableModelListener((TableModelListener & Serializable)event -> this.refresh());
        this.doLayout();
    }

    public void setFocusTraversalIndex(int newValue) {
        this.first.setFocusTraversalIndex(newValue);
        this.previous.setFocusTraversalIndex(newValue);
        this.pageSelector.setFocusTraversalIndex(newValue);
        this.next.setFocusTraversalIndex(newValue);
        this.last.setFocusTraversalIndex(newValue);
    }

    public void setFocusTraversalParticipant(boolean newValue) {
        this.first.setFocusTraversalParticipant(newValue);
        this.previous.setFocusTraversalParticipant(newValue);
        this.pageSelector.setFocusTraversalParticipant(newValue);
        this.next.setFocusTraversalParticipant(newValue);
        this.last.setFocusTraversalParticipant(newValue);
    }

    public boolean first() {
        boolean result = false;
        int page = this.getModel().getPage();
        if (page != 0) {
            result = this.changePage(0);
        }
        return result;
    }

    public boolean previous() {
        boolean result = false;
        PageableTableModel model = this.getModel();
        int page = model.getPage();
        if (page > 0) {
            result = this.changePage(page - 1);
        }
        return result;
    }

    public boolean next() {
        PageableTableModel model = this.getModel();
        int page = model.getPage();
        return this.changePage(page + 1);
    }

    public boolean last() {
        boolean result = false;
        PageableTableModel model = this.getModel();
        int lastPage = this.getLastPage();
        int page = model.getPage();
        if (page != lastPage) {
            result = this.changePage(lastPage);
        }
        return result;
    }

    public boolean hasPreviousRow() {
        boolean result = false;
        int index = this.getSelected();
        if (index != -1) {
            if (index > 0) {
                result = true;
            } else {
                int page = this.getModel().getPage();
                if (page > 0) {
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean selectPreviousRow() {
        boolean result = false;
        int index = this.getSelected();
        if (index != -1) {
            int count;
            if (index > 0) {
                this.select(index - 1);
                result = true;
            } else if (this.previous() && (count = this.getModel().getRowCount()) > 0) {
                this.select(count - 1);
                result = true;
            }
        }
        return result;
    }

    public boolean hasNextRow() {
        boolean result = false;
        int index = this.getSelected();
        if (index != -1) {
            PageableTableModel model = this.getModel();
            int count = model.getRowCount();
            if (index + 1 < count) {
                result = true;
            } else {
                int page = this.getModel().getPage();
                if (model.hasPage(page + 1)) {
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean selectNextRow() {
        boolean result = false;
        int index = this.getSelected();
        if (index != -1) {
            PageableTableModel model = this.getModel();
            int count = model.getRowCount();
            if (index + 1 < count) {
                this.select(index + 1);
                result = true;
            } else if (this.next() && model.getRowCount() > 0) {
                this.select(0);
                result = true;
            }
        }
        return result;
    }

    public void setPage(int page) {
        this.changePage(page);
    }

    protected void doLayout() {
        this.setCellSpacing(new Extent(10));
        Label page = LabelFactory.create("navigation.page");
        this.first = ButtonFactory.create(null, "navigation.first", this::first);
        this.previous = ButtonFactory.create(null, "navigation.previous", this::previous);
        this.pageSelector = new SelectField();
        this.pageSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                int selected = TableNavigator.this.pageSelector.getSelectedIndex();
                PageableTableModel model = TableNavigator.this.getModel();
                model.setPage(selected);
            }
        });
        this.pageCount = LabelFactory.create();
        this.next = ButtonFactory.create(null, "navigation.next", this::next);
        this.last = ButtonFactory.create(null, "navigation.last", this::last);
        this.add((Component)page);
        this.add((Component)this.first);
        this.add((Component)this.previous);
        this.add((Component)this.pageSelector);
        this.add((Component)this.next);
        this.add((Component)this.last);
        this.add((Component)this.pageCount);
        this.refresh();
    }

    protected boolean changePage(int page) {
        boolean result = false;
        PageableTableModel model = this.getModel();
        if (model.setPage(page)) {
            this.table.setSelectionModel((ListSelectionModel)new DefaultListSelectionModel());
            this.pageSelector.setSelectedIndex(page);
            result = true;
        } else if (model.getPage() == page - 1) {
            this.setTotal(model.getPage() + 1);
        }
        return result;
    }

    protected void refresh() {
        PageableTableModel model = this.getModel();
        int pages = this.getPages();
        if (pages != this.pageSelector.getModel().size()) {
            this.setTotal(pages);
            Object[] pageNos = new String[pages];
            for (int i = 0; i < pageNos.length; ++i) {
                pageNos[i] = "" + (i + 1);
            }
            this.pageSelector.setModel((ListModel)new DefaultListModel(pageNos));
        }
        int selected = model.getPage();
        this.pageSelector.setSelectedIndex(selected);
    }

    protected PageableTableModel getModel() {
        return (PageableTableModel)this.table.getModel();
    }

    private void setTotal(int pages) {
        String total = this.getModel().isEstimatedActual() ? Messages.format((String)"navigation.page.total", (Object[])new Object[]{pages}) : Messages.format((String)"navigation.page.totalunknown", (Object[])new Object[]{pages});
        this.pageCount.setText(total);
    }

    private int getPages() {
        PageableTableModel model = this.getModel();
        return model.getEstimatedPages();
    }

    private int getLastPage() {
        int pages = this.getModel().getPages();
        return pages > 0 ? pages - 1 : 0;
    }

    private int getSelected() {
        return this.table.getSelectionModel().getMinSelectedIndex();
    }

    private void select(int index) {
        this.table.getSelectionModel().setSelectedIndex(index, true);
    }
}

