/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.table;

import echopointng.EPNG;
import echopointng.layout.TableLayoutDataEx;
import echopointng.ui.resource.Resources;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import echopointng.xhtml.XhtmlFragment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.layout.TableLayoutData;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webcontainer.propertyrender.CellLayoutDataRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.openvpms.web.echo.table.TableEx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableExPeer
extends echopointng.ui.syncpeer.TableExPeer {
    private static final Service TABLEEX_SERVICE = JavaScriptService.forResource((String)"EPNG.TableEx", (String)"/org/openvpms/web/echo/js/TableEx.js");

    public void renderHtml(RenderContext rcOrig, ServerComponentUpdate update, Node parentNode, Component component) {
        String defaultInsetsAttributeValue;
        RenderingContext rc = new RenderingContext(rcOrig, update, component);
        Style fallbackStyle = EPNG.getFallBackStyle((Component)component);
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        serverMessage.addLibrary(Resources.EP_DRAG_SERVICE.getId());
        serverMessage.addLibrary(TABLEEX_SERVICE.getId());
        TableEx table = (TableEx)component;
        String elementId = ContainerInstance.getElementId((Component)table);
        Element itemXML = this.renderInitDirective(rc, table, fallbackStyle);
        Document document = parentNode.getOwnerDocument();
        Border border = (Border)rc.getRP("border", fallbackStyle);
        Extent borderSize = border == null ? null : border.getSize();
        Extent width = (Extent)rc.getRP("width", fallbackStyle);
        Extent height = (Extent)rc.getRP("height", fallbackStyle);
        boolean selectionEnabled = rc.getRP("selectionEnabled", fallbackStyle, false);
        boolean headerVisible = table.isHeaderVisible();
        boolean footerVisible = table.isFooterVisible();
        int rowCount = table.getModel().getRowCount();
        Insets tableInsets = (Insets)rc.getRP("insets", fallbackStyle);
        String string = defaultInsetsAttributeValue = tableInsets == null ? "0px" : InsetsRender.renderCssAttributeValue((Insets)tableInsets);
        if (rc.getRP("scrollable", fallbackStyle, false)) {
            Element contentDivE;
            Element outerDivE = document.createElement("div");
            outerDivE.setAttribute("id", elementId);
            outerDivE.setAttribute("style", "padding:0px;margin:0px");
            rc.addStandardWebSupport(component, outerDivE);
            if (headerVisible) {
                contentDivE = this.renderResizeableHeaderFooterAreas(rc, table, fallbackStyle, border, defaultInsetsAttributeValue, itemXML, -1, headerVisible, "header", rowCount);
                outerDivE.appendChild(contentDivE);
            }
            contentDivE = document.createElement("div");
            CssStyleEx style = new CssStyleEx(component, fallbackStyle);
            style.setAttribute("overflow", "auto");
            style.setAttribute("padding", "0px");
            style.setAttribute("margin", "0px");
            ExtentRender.renderToStyle((CssStyle)style, (String)"width", (Extent)width);
            if (rowCount > 0) {
                ExtentRender.renderToStyle((CssStyle)style, (String)"height", (Extent)height);
                Render.asBorder((CssStyle)style, (Border)border);
                if (headerVisible) {
                    style.setAttribute("border-top-width", "0px");
                }
            }
            contentDivE.setAttribute("style", style.renderInline());
            contentDivE.setAttribute("id", elementId + "_contentDiv");
            Element tbodyElement = document.createElement("table");
            style = new CssStyleEx();
            style.setAttribute("table-layout", "fixed");
            style.setAttribute("width", "100%");
            if (selectionEnabled && rowCount > 0) {
                style.setAttribute("cursor", "pointer");
            }
            tbodyElement.setAttribute("style", style.renderInline());
            tbodyElement.setAttribute("id", elementId + "_contentTable");
            tbodyElement.setAttribute("cellpadding", "0");
            tbodyElement.setAttribute("cellspacing", "0");
            tbodyElement.setAttribute("border", "0");
            Element colgroupE = this.renderColGroup(table, document);
            if (colgroupE != null) {
                tbodyElement.appendChild(colgroupE);
            }
            Element contentTbodyElement = document.createElement("tbody");
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.renderRow(rc, contentTbodyElement, table, rowIndex, defaultInsetsAttributeValue, itemXML, fallbackStyle);
            }
            tbodyElement.appendChild(contentTbodyElement);
            contentDivE.appendChild(tbodyElement);
            outerDivE.appendChild(contentDivE);
            if (footerVisible) {
                Element footerDivE = this.renderResizeableHeaderFooterAreas(rc, table, fallbackStyle, border, defaultInsetsAttributeValue, itemXML, -2, footerVisible, "footer", rowCount);
                outerDivE.appendChild(footerDivE);
            }
            parentNode.appendChild(outerDivE);
        } else {
            Element tableElement = document.createElement("table");
            tableElement.setAttribute("id", elementId);
            rc.addStandardWebSupport(component, tableElement);
            CssStyleEx tableCssStyle = new CssStyleEx(component, fallbackStyle);
            tableCssStyle.setAttribute("border-collapse", "collapse");
            if (selectionEnabled) {
                tableCssStyle.setAttribute("cursor", "pointer");
            }
            ColorRender.renderToStyle((CssStyle)tableCssStyle, (Component)component);
            FontRender.renderToStyle((CssStyle)tableCssStyle, (Component)component);
            BorderRender.renderToStyle((CssStyle)tableCssStyle, (Border)border);
            if (borderSize != null && !rc.getContainerInstance().getClientProperties().getBoolean("quirkCssBorderCollapseInside")) {
                tableCssStyle.setAttribute("margin", ExtentRender.renderCssAttributeValueHalf((Extent)borderSize));
            }
            if (rc.getContainerInstance().getClientProperties().getBoolean("quirkIETablePercentWidthScrollbarError") && width != null && width.getUnits() == 2 && width.getValue() > 95) {
                width = new Extent(95, 2);
            }
            ExtentRender.renderToStyle((CssStyle)tableCssStyle, (String)"width", (Extent)width);
            tableElement.setAttribute("style", tableCssStyle.renderInline());
            parentNode.appendChild(tableElement);
            Element contentDivE = this.renderColGroup(table, document);
            if (contentDivE != null) {
                tableElement.appendChild(contentDivE);
            }
            if (table.isHeaderVisible()) {
                Element theadElement = document.createElement("thead");
                theadElement.setAttribute("id", elementId + "_thead");
                tableElement.appendChild(theadElement);
                this.renderRow(rc, theadElement, table, -1, defaultInsetsAttributeValue, itemXML, fallbackStyle);
            }
            Element tbodyElement = document.createElement("tbody");
            tbodyElement.setAttribute("id", elementId + "_tbody");
            tableElement.appendChild(tbodyElement);
            int rows = table.getModel().getRowCount();
            for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                this.renderRow(rc, tbodyElement, table, rowIndex, defaultInsetsAttributeValue, itemXML, fallbackStyle);
            }
            if (table.isFooterVisible()) {
                this.renderRow(rc, tbodyElement, table, -2, defaultInsetsAttributeValue, itemXML, fallbackStyle);
            }
        }
    }

    protected Element renderInitDirective(RenderingContext rc, echopointng.TableEx table, Style fallbackStyle) {
        Element element = super.renderInitDirective(rc, table, fallbackStyle);
        Integer row = ((TableEx)table).getScrollToRow();
        if (row != null) {
            element.setAttribute("scrollToRow", Integer.toString(row));
            ((TableEx)table).resetScrollToRow();
        }
        return element;
    }

    protected void renderRow(RenderingContext rc, Element parent, TableEx table, int rowIndex, String defaultInsetsAttributeValue, Element itemXML, Style fallbackStyle) {
        Document document = parent.getOwnerDocument();
        String elementId = ContainerInstance.getElementId((Component)table);
        boolean isScrollable = rc.getRP("scrollable", fallbackStyle, false);
        Element trElement = document.createElement("tr");
        if (rowIndex == -1) {
            trElement.setAttribute("id", elementId + "_tr_header");
        } else if (rowIndex == -2) {
            trElement.setAttribute("id", elementId + "_tr_footer");
        } else {
            trElement.setAttribute("id", elementId + "_tr_" + rowIndex);
        }
        parent.appendChild(trElement);
        int columns = table.getColumnModel().getColumnCount();
        int rowCount = table.getModel().getRowCount();
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            Object cellContent = table.getCellContent(columnIndex, rowIndex);
            if (cellContent == null || cellContent == TableEx.CELL_SPANNER) continue;
            Element tdCellE = rowIndex == -1 ? document.createElement("th") : document.createElement("td");
            Border border = (Border)rc.getRP("border", fallbackStyle);
            tdCellE.setAttribute("c", String.valueOf(columnIndex));
            trElement.appendChild(tdCellE);
            Element cellContentE = tdCellE;
            CssStyle style = new CssStyle();
            if (rowIndex == -1 && table.isHeaderFixed()) {
                style.setAttribute("position", "sticky");
                if (border != null) {
                    style.setAttribute("top", "-" + border.getSize());
                }
                style.setAttribute("background-clip", "padding-box");
            }
            if (!isScrollable) {
                Render.asBorder((CssStyle)style, (Border)border);
            } else {
                Element cellDivE = document.createElement("div");
                tdCellE.appendChild(cellDivE);
                cellContentE = cellDivE;
            }
            String cellId = null;
            TableEx renderComponent = table;
            Component childComponent = null;
            TableLayoutData tableLayoutData = null;
            TableLayoutDataEx tableLayoutDataEx = null;
            if (cellContent instanceof XhtmlFragment) {
                XhtmlFragment fragment = (XhtmlFragment)cellContent;
                cellId = elementId + "_cell_col" + columnIndex + "row" + rowIndex;
                tableLayoutData = this.getLayoutData(fragment);
                if (tableLayoutData instanceof TableLayoutDataEx) {
                    tableLayoutDataEx = (TableLayoutDataEx)tableLayoutData;
                }
                this.renderXhtmlFragment(rc, cellContentE, itemXML, cellId, fragment, rowCount);
            }
            if (cellContent instanceof Component) {
                childComponent = (Component)cellContent;
                renderComponent = childComponent;
                cellId = elementId + "_cell_" + childComponent.getRenderId();
                tableLayoutData = this.getLayoutData(childComponent);
                if (tableLayoutData instanceof TableLayoutDataEx) {
                    tableLayoutDataEx = (TableLayoutDataEx)tableLayoutData;
                }
            }
            if (childComponent != null) {
                this.renderAddChild(rc, cellContentE, childComponent);
            }
            if (rowIndex == -1) {
                Render.asColor((CssStyle)style, (Color)((Color)rc.getRP("headerBackground", fallbackStyle)), (String)"background");
            }
            if (rowIndex == -2) {
                Render.asColor((CssStyle)style, (Color)((Color)rc.getRP("footerBackground", fallbackStyle)), (String)"background");
            }
            CellLayoutDataRender.renderToElementAndStyle((Element)cellContentE, (CssStyle)style, (Component)renderComponent, tableLayoutData, (String)defaultInsetsAttributeValue);
            if (tableLayoutData != null && tableLayoutData.getBackgroundImage() != null) {
                Render.asBackgroundImage((RenderContext)rc, (CssStyle)style, (FillImage)tableLayoutData.getBackgroundImage());
            }
            if (isScrollable) {
                style.setAttribute("width", "100%");
                style.setAttribute("overflow", "hidden");
                style.setAttribute("white-space", "nowrap");
            }
            String inlineStyle = style.renderInline();
            if (rowIndex == -1 && table.isHeaderFixed()) {
                inlineStyle = "position:-webkit-sticky;" + inlineStyle;
            }
            cellContentE.setAttribute("style", inlineStyle);
            cellContentE.setAttribute("id", cellId);
            if (tableLayoutDataEx == null) continue;
            if (tableLayoutDataEx.getToolTipText() != null) {
                cellContentE.setAttribute("title", tableLayoutDataEx.getToolTipText());
            }
            int colSpan = tableLayoutDataEx.getColSpan();
            int rowSpan = tableLayoutDataEx.getRowSpan();
            if (colSpan > 1) {
                tdCellE.setAttribute("colspan", String.valueOf(colSpan));
            }
            if (rowSpan <= 1) continue;
            tdCellE.setAttribute("rowspan", String.valueOf(rowSpan));
        }
        boolean statusQuo = true;
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            if (table.isActionCausingCell(columnIndex, rowIndex) && table.isSelectionCausingCell(columnIndex, rowIndex)) continue;
            statusQuo = false;
            break;
        }
        if (!statusQuo) {
            Element selectionElement;
            StringBuilder actionCausingStr = new StringBuilder();
            StringBuilder selectionCausingStr = new StringBuilder();
            for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
                if (!table.isActionCausingCell(columnIndex, rowIndex)) {
                    actionCausingStr.append("c:");
                    actionCausingStr.append(columnIndex);
                    actionCausingStr.append(";");
                }
                if (table.isSelectionCausingCell(columnIndex, rowIndex)) continue;
                selectionCausingStr.append("c:");
                selectionCausingStr.append(columnIndex);
                selectionCausingStr.append(";");
            }
            Document documentXML = itemXML.getOwnerDocument();
            if (actionCausingStr.length() > 0) {
                selectionElement = documentXML.createElement("actionCausingCell");
                itemXML.appendChild(selectionElement);
                selectionElement.setAttribute("row", String.valueOf(rowIndex));
                selectionElement.setAttribute("cells", actionCausingStr.toString());
            }
            if (selectionCausingStr.length() > 0) {
                selectionElement = documentXML.createElement("selectionCausingCell");
                itemXML.appendChild(selectionElement);
                selectionElement.setAttribute("row", String.valueOf(rowIndex));
                selectionElement.setAttribute("cells", selectionCausingStr.toString());
            }
        }
    }

    private void renderAddChild(RenderingContext rc, Element parentElement, Component child) {
        if (child.isVisible()) {
            ServerComponentUpdate update = rc.getServerComponentUpdate();
            ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
            if (syncPeer instanceof DomUpdateSupport) {
                ((DomUpdateSupport)syncPeer).renderHtml((RenderContext)rc, update, (Node)parentElement, child);
            } else {
                syncPeer.renderAdd((RenderContext)rc, update, this.getContainerId(child), child);
            }
        }
    }

    private TableLayoutData getLayoutData(Component child) {
        LayoutData layoutData = (LayoutData)child.getRenderProperty("layoutData");
        if (layoutData == null) {
            return null;
        }
        if (layoutData instanceof TableLayoutData) {
            return (TableLayoutData)layoutData;
        }
        throw new RuntimeException("Invalid LayoutData for Table Child: " + layoutData.getClass().getName());
    }

    private TableLayoutData getLayoutData(XhtmlFragment fragment) {
        LayoutData layoutData = fragment.getLayoutData();
        if (layoutData == null) {
            return null;
        }
        if (layoutData instanceof TableLayoutData) {
            return (TableLayoutData)layoutData;
        }
        throw new RuntimeException("Invalid LayoutData for Table: " + layoutData.getClass().getName());
    }

    private Element renderResizeableHeaderFooterAreas(RenderingContext rc, TableEx table, Style fallbackStyle, Border border, String defaultInsetsAttributeValue, Element itemXML, int rowIndex, boolean isVisible, String prefixName, int rowCount) {
        Document document = rc.getDocument();
        Element headerFooterDivE = document.createElement("div");
        CssStyleEx style = new CssStyleEx((Component)table, fallbackStyle);
        style.setAttribute("width", "100%");
        style.setAttribute("overflow", "hidden");
        style.setAttribute("position", "relative");
        style.setAttribute("padding", "0px");
        style.setAttribute("margin", "0px");
        if (isVisible) {
            if (rowIndex == -1) {
                Render.asColor((CssStyle)style, (Color)((Color)rc.getRP("headerBackground", fallbackStyle)), (String)"background");
            }
            if (rowIndex == -2) {
                Render.asColor((CssStyle)style, (Color)((Color)rc.getRP("footerBackground", fallbackStyle)), (String)"background");
            }
            if (isVisible && rowIndex == -1) {
                Render.asBorder((CssStyle)style, (Border)border);
                if (rowCount > 0) {
                    style.setAttribute("border-bottom-width", style.getAttribute("border-top-width"));
                    style.setAttribute("border-bottom-color", style.getAttribute("border-top-color"));
                    style.setAttribute("border-bottom-style", style.getAttribute("border-top-style"));
                }
            }
            if (isVisible && rowIndex == -2) {
                Render.asBorder((CssStyle)style, (Border)border);
                if (rowCount > 0) {
                    style.setAttribute("border-top-width", "0px");
                }
            }
        }
        headerFooterDivE.setAttribute("style", style.renderInline());
        headerFooterDivE.setAttribute("id", rc.getElementId() + "_" + prefixName + "Div");
        Element headerFooterScrollerDivE = document.createElement("div");
        style = new CssStyleEx();
        style.setAttribute("width", "100%");
        style.setAttribute("position", "relative");
        style.setAttribute("padding", "0px");
        style.setAttribute("margin", "0px");
        headerFooterScrollerDivE.setAttribute("style", style.renderInline());
        headerFooterScrollerDivE.setAttribute("id", rc.getElementId() + "_" + prefixName + "ScrollerDiv");
        Element headerFooterTableE = document.createElement("table");
        style = new CssStyleEx();
        style.setAttribute("table-layout", "fixed");
        style.setAttribute("width", "100%");
        headerFooterTableE.setAttribute("style", style.renderInline());
        headerFooterTableE.setAttribute("id", rc.getElementId() + "_" + prefixName + "Table");
        headerFooterTableE.setAttribute("cellpadding", "0");
        headerFooterTableE.setAttribute("cellspacing", "0");
        headerFooterTableE.setAttribute("border", "0");
        Element headerFooterTbodyElement = document.createElement("tbody");
        headerFooterTableE.appendChild(headerFooterTbodyElement);
        if (isVisible) {
            this.renderRow(rc, headerFooterTbodyElement, table, rowIndex, defaultInsetsAttributeValue, itemXML, fallbackStyle);
        }
        headerFooterTableE.appendChild(headerFooterTbodyElement);
        headerFooterScrollerDivE.appendChild(headerFooterTableE);
        headerFooterDivE.appendChild(headerFooterScrollerDivE);
        return headerFooterDivE;
    }

    static {
        WebRenderServlet.getServiceRegistry().remove(TABLEEX_SERVICE);
        WebRenderServlet.getServiceRegistry().add(TABLEEX_SERVICE);
    }
}

