/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.table;

import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.ResourceImageReference;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.TableCellRenderer;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.table.SortableTableModel;
import org.openvpms.web.echo.table.TableHelper;

public class SortableTableHeaderRenderer
implements TableCellRenderer {
    private final String style;
    private static final String UP_ARROW_PATH = "/echopointng/resource/images/ArrowUp.gif";
    private static final String DOWN_ARROW_PATH = "/echopointng/resource/images/ArrowDown.gif";
    private static final ImageReference UP_ARROW = new ResourceImageReference("/echopointng/resource/images/ArrowUp.gif");
    private static final String STYLE = "Table.Header";
    private static final ImageReference DOWN_ARROW = new ResourceImageReference("/echopointng/resource/images/ArrowDown.gif");

    public SortableTableHeaderRenderer() {
        this(STYLE);
    }

    public SortableTableHeaderRenderer(String style) {
        this.style = style;
    }

    public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
        Component result;
        SortableTableModel model = (SortableTableModel)table.getModel();
        if (value instanceof Component) {
            result = (Component)value;
            TableHelper.mergeStyle(result, this.style);
        } else {
            String text;
            String string = text = value != null ? value.toString() : null;
            if (model.isSortable(column)) {
                result = this.getSortButton(text, column, model);
            } else {
                Label label = LabelFactory.create(null, this.style);
                label.setText(text);
                result = label;
            }
        }
        return result;
    }

    protected Button getSortButton(String label, final int column, final SortableTableModel model) {
        Button button = new Button();
        button.setStyleName(this.style);
        button.setText(label);
        button.setFocusTraversalParticipant(false);
        button.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            @Override
            public void onAction(ActionEvent e) {
                boolean ascending = false;
                if (column == model.getSortColumn()) {
                    ascending = model.isSortedAscending();
                }
                model.sort(column, !ascending);
            }
        });
        if (model.getSortColumn() == column) {
            ImageReference icon = model.isSortedAscending() ? DOWN_ARROW : UP_ARROW;
            button.setIcon(icon);
        }
        return button;
    }
}

