/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.servlet;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.WebRenderServlet;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.openvpms.web.echo.spring.SpringApplicationInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class SessionMonitor
implements DisposableBean {
    public static final int DEFAULT_AUTO_LOCK_INTERVAL = 5;
    public static final int DEFAULT_AUTO_LOGOUT_INTERVAL = 30;
    private final AtomicLong counter = new AtomicLong();
    private final Map<HttpSession, Monitor> monitors = Collections.synchronizedMap(new WeakHashMap());
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private volatile long autoLock = 300000L;
    private volatile long autoLogout = 1800000L;
    private static final Logger log = LoggerFactory.getLogger(SessionMonitor.class);

    public SessionMonitor() {
        log.info("Using default session auto-lock time={} minutes", (Object)(this.autoLock / 60000L));
        log.info("Using default session auto-logout time={} minutes", (Object)(this.autoLogout / 60000L));
    }

    public void addSession(HttpSession session) {
        Monitor monitor = new Monitor(session, this.counter.getAndIncrement());
        this.monitors.put(session, monitor);
        monitor.schedule();
    }

    public void removeSession(HttpSession session) {
        Monitor monitor = this.monitors.remove(session);
        if (monitor != null) {
            monitor.destroy();
        }
    }

    public void active() {
        Connection connection = this.getConnection();
        if (connection != null) {
            HttpServletRequest request = connection.getRequest();
            this.active(request, this.getAuthentication());
        }
    }

    public void active(HttpServletRequest request, Authentication authentication) {
        Monitor monitor = this.monitors.get(request.getSession());
        if (monitor != null) {
            monitor.active(request, authentication);
        }
    }

    public boolean isLocked(HttpSession session) {
        Monitor monitor = this.monitors.get(session);
        return monitor != null && monitor.status != Status.UNLOCKED;
    }

    public void newApplication(SpringApplicationInstance application, HttpSession session) {
        Monitor monitor = this.monitors.get(session);
        if (monitor != null) {
            monitor.newApplication(application);
        }
    }

    public int getAutoLock() {
        return (int)(this.autoLock / 60000L);
    }

    public void setAutoLock(int time) {
        this.setAutoLockMS((long)time * 60000L);
    }

    public void locked() {
        Monitor monitor;
        Connection connection = this.getConnection();
        if (connection != null && (monitor = this.monitors.get(connection.getRequest().getSession())) != null) {
            monitor.locked();
        }
    }

    public void unlock() {
        Monitor monitor;
        Connection connection = this.getConnection();
        if (connection != null && (monitor = this.monitors.get(connection.getRequest().getSession())) != null) {
            monitor.unlock();
        }
    }

    public long getCurrentSessionMonitorId() {
        Monitor monitor;
        HttpSession session;
        long result = -1L;
        Connection connection = this.getConnection();
        if (connection != null && (session = connection.getRequest().getSession(false)) != null && (monitor = this.monitors.get(session)) != null) {
            result = monitor.getId();
        }
        return result;
    }

    public void setAutoLogout(int time) {
        this.setAutoLogoutMS((long)time * 60000L);
    }

    public List<Session> getSessions() {
        ArrayList<Session> result = new ArrayList<Session>();
        for (Monitor monitor : new ArrayList<Monitor>(this.monitors.values())) {
            Session session = monitor.getSession();
            if (session == null) continue;
            result.add(session);
        }
        return result;
    }

    public boolean terminate(Session session) {
        Monitor found = this.monitors.values().stream().filter(monitor -> session.getId() == monitor.getId()).findFirst().orElse(null);
        if (found != null) {
            found.invalidate();
        }
        return found != null;
    }

    public void destroy() {
        log.info("Shutting down SessionMonitor");
        this.executor.shutdownNow();
        try {
            if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                log.error("Pool did not terminate");
            }
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
        }
        this.monitors.clear();
    }

    protected Connection getConnection() {
        return WebRenderServlet.getActiveConnection();
    }

    protected Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    protected void setAutoLockMS(long time) {
        if (time != this.autoLock) {
            this.autoLock = time;
            if (time == 0L) {
                log.warn("Sessions configured to not auto-lock");
            } else {
                log.info("Using session auto-lock time={} minutes", (Object)(time / 60000L));
            }
            this.reschedule();
        }
    }

    protected void setAutoLogoutMS(long time) {
        if (time != this.autoLogout) {
            this.autoLogout = time;
            if (time == 0L) {
                log.warn("Sessions configured to not auto-logout");
            } else {
                log.info("Using session auto-logout time={} minutes", (Object)(time / 60000L));
            }
            this.reschedule();
        }
    }

    private void reschedule() {
        for (Object state : this.monitors.values().toArray()) {
            ((Monitor)state).reschedule();
        }
    }

    private static enum Status {
        UNLOCKED,
        LOCK_PENDING,
        LOCKED;

    }

    private class Monitor
    implements Runnable {
        private final WeakReference<HttpSession> session;
        private final ReferenceMap<SpringApplicationInstance, SpringApplicationInstance> apps = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.WEAK);
        private final long id;
        private volatile Status status = Status.UNLOCKED;
        private volatile long lastAccessedTime = System.currentTimeMillis();
        private volatile ScheduledFuture<?> future;
        private volatile String user;
        private volatile String address;

        public Monitor(HttpSession session, long id) {
            this.session = new WeakReference<HttpSession>(session);
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public void active(HttpServletRequest request, Authentication authentication) {
            this.lastAccessedTime = System.currentTimeMillis();
            boolean noUser = this.user == null;
            Object principal = authentication.getPrincipal();
            String currentUser = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : principal.toString();
            this.user = currentUser;
            this.address = request.getRemoteAddr();
            if (noUser && currentUser != null) {
                log.info("Active session, user={}, address={}, status={}, monitor={}", new Object[]{currentUser, this.address, this.status, this.id});
            }
            if (this.status == Status.LOCK_PENDING) {
                this.unlock();
            }
        }

        public synchronized void newApplication(SpringApplicationInstance application) {
            this.apps.put((Object)application, (Object)application);
        }

        @Override
        public synchronized void run() {
            try {
                this.monitor();
            }
            catch (Throwable exception) {
                log.error(exception.getMessage(), exception);
            }
        }

        public void schedule() {
            long time = SessionMonitor.this.autoLock;
            long logout = SessionMonitor.this.autoLogout;
            if (time == 0L || logout != 0L && logout < time) {
                time = logout;
            }
            if (time != 0L) {
                this.schedule(time);
            }
        }

        public void reschedule() {
            long timeout;
            ScheduledFuture<?> current = this.future;
            if (current != null) {
                current.cancel(false);
            }
            if ((timeout = SessionMonitor.this.autoLock) == 0L) {
                timeout = SessionMonitor.this.autoLogout;
            }
            if (timeout != 0L) {
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void unlock() {
            try {
                SpringApplicationInstance[] list;
                for (SpringApplicationInstance app : list = this.apps.values().toArray(new SpringApplicationInstance[0])) {
                    if (app == null) continue;
                    app.unlock();
                }
            }
            finally {
                this.status = Status.UNLOCKED;
                this.reschedule();
            }
            log.info("Unlocked session for user={}, address={}, monitor={}", new Object[]{this.user, this.address, this.id});
        }

        public Session getSession() {
            Session result = null;
            String name = this.user;
            HttpSession httpSession = (HttpSession)this.session.get();
            if (name != null && httpSession != null) {
                try {
                    Date created = new Date(httpSession.getCreationTime());
                    Date lastAccessed = new Date(this.lastAccessedTime);
                    result = new Session(this.id, name, this.address, created, lastAccessed);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return result;
        }

        public void destroy() {
            ScheduledFuture<?> current = this.future;
            if (current != null) {
                current.cancel(true);
            }
        }

        private void monitor() {
            long inactive = System.currentTimeMillis() - this.lastAccessedTime;
            long logout = SessionMonitor.this.autoLogout;
            long lock = SessionMonitor.this.autoLock;
            if (log.isDebugEnabled()) {
                log.debug("Monitor user={}, address={}, monitor={}, inactive={}, logout={}, lock={}", new Object[]{this.user, this.address, this.id, DurationFormatUtils.formatDurationHMS((long)inactive), DurationFormatUtils.formatDurationHMS((long)logout), DurationFormatUtils.formatDurationHMS((long)lock)});
            }
            if (logout != 0L && inactive >= logout) {
                this.invalidate();
            } else {
                long reschedule;
                long l = reschedule = logout != 0L ? logout - inactive : 0L;
                if (lock != 0L && lock < logout) {
                    if (inactive >= lock) {
                        if (this.status == Status.UNLOCKED) {
                            this.lock();
                        }
                    } else {
                        reschedule = lock - inactive;
                    }
                }
                if (reschedule != 0L) {
                    this.schedule(reschedule);
                }
            }
        }

        private void schedule(long delay) {
            if (log.isDebugEnabled()) {
                log.debug("Scheduling monitor in {},  user={}, address={}, monitor={}", new Object[]{DurationFormatUtils.formatDurationHMS((long)delay), this.user, this.address, this.id});
            }
            this.future = SessionMonitor.this.executor.schedule(this, delay, TimeUnit.MILLISECONDS);
        }

        private synchronized void lock() {
            SpringApplicationInstance[] list;
            this.status = Status.LOCK_PENDING;
            int count = 0;
            for (SpringApplicationInstance app : list = this.apps.values().toArray(new SpringApplicationInstance[0])) {
                if (app == null) continue;
                ++count;
                app.lock();
            }
            log.info("Locking {} apps for user={}, address={}, monitor={}", new Object[]{count, this.user, this.address, this.id});
        }

        private void locked() {
            this.status = Status.LOCKED;
            log.info("Locked session for user={}, address={}, monitor={}", new Object[]{this.user, this.address, this.id});
        }

        private void invalidate() {
            SpringApplicationInstance[] list;
            for (SpringApplicationInstance app : list = this.apps.values().toArray(new SpringApplicationInstance[0])) {
                if (app == null) continue;
                try {
                    app.dispose();
                }
                catch (Throwable exception) {
                    log.debug("Error disposing app", exception);
                }
            }
            HttpSession httpSession = (HttpSession)this.session.get();
            if (httpSession != null) {
                this.session.clear();
                httpSession.invalidate();
                log.info("Invalidated session, monitor={} for user={}, address={}", new Object[]{this.id, this.user, this.address});
            } else {
                log.info("Session with monitor={} for user={}, address={} garbage collected", new Object[]{this.id, this.user, this.address});
            }
        }
    }

    public static class Session {
        private final long id;
        private final String name;
        private final String host;
        private final Date loggedIn;
        private final Date lastAccessed;

        public Session(long id, String name, String host, Date loggedIn, Date lastAccessed) {
            this.id = id;
            this.name = name;
            this.host = host;
            this.loggedIn = loggedIn;
            this.lastAccessed = lastAccessed;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getHost() {
            return this.host;
        }

        public Date getLoggedIn() {
            return this.loggedIn;
        }

        public Date getLastAccessed() {
            return this.lastAccessed;
        }
    }
}

