/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.image;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.StreamImageReference;
import org.apache.commons.io.IOUtils;

public class ThumbnailImageReference
extends StreamImageReference {
    private final byte[] content;
    private final String mimeType;
    private final String id = ApplicationInstance.generateSystemId();

    public ThumbnailImageReference(byte[] content, String mimeType) {
        this.content = content;
        this.mimeType = mimeType;
    }

    public String getContentType() {
        return this.mimeType;
    }

    public void render(OutputStream out) throws IOException {
        IOUtils.copy((InputStream)new ByteArrayInputStream(this.content), (OutputStream)out);
    }

    public String getRenderId() {
        return this.id;
    }

    public static ThumbnailImageReference create(InputStream stream, String mimeType) {
        try {
            byte[] content = IOUtils.toByteArray((InputStream)stream);
            if (content.length > 0) {
                return new ThumbnailImageReference(content, mimeType);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

