/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.help;

import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.echo.help.HelpListener;

public class HelpContext {
    private final HelpContext parent;
    private final String topic;
    private final int keyCode;
    private final HelpListener listener;

    public HelpContext(String topic, HelpListener listener) {
        this(null, topic, listener);
    }

    public HelpContext(HelpContext parent, String topic) {
        this(parent, topic, parent.listener);
    }

    private HelpContext(HelpContext parent, String topic, HelpListener listener) {
        this.parent = parent;
        this.topic = topic;
        this.listener = listener;
        this.keyCode = 4208;
    }

    public String getTopic() {
        return this.topic;
    }

    public HelpContext getParent() {
        return this.parent;
    }

    public HelpContext topic(String topic) {
        return new HelpContext(this, topic, this.listener);
    }

    public HelpContext topic(IMObject object, String subtopic) {
        return this.topic(object.getArchetype() + "/" + subtopic);
    }

    public HelpContext subtopic(String topic) {
        return new HelpContext(this, this.topic + "/" + topic, this.listener);
    }

    public void show() {
        this.listener.show(this);
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public String toString() {
        String result = this.topic;
        if (this.parent != null) {
            result = result + "\n" + this.parent.toString();
        }
        return result;
    }
}

