/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.focus;

import echopointng.DateField;
import echopointng.DropDown;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.DelegateFocusSupport;
import nextapp.echo2.app.ListBox;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.button.AbstractButton;
import nextapp.echo2.app.text.TextComponent;
import org.openvpms.web.echo.colour.ColorSelect;
import org.openvpms.web.echo.table.KeyTable;

public class FocusHelper {
    public static Component getFocusable(Component component) {
        Object result = null;
        if (component != null) {
            if (FocusHelper.isFocusable(component)) {
                result = component instanceof DateField ? ((DateField)component).getTextField() : (component instanceof DelegateFocusSupport ? ((DelegateFocusSupport)component).getFocusComponent() : component);
            } else if (component.getComponentCount() != 0) {
                Component child;
                Component[] componentArray = component.getComponents();
                int n = componentArray.length;
                for (int i = 0; i < n && (result = FocusHelper.getFocusable(child = componentArray[i])) == null; ++i) {
                }
            }
        }
        return result;
    }

    public static Component setFocus(Component component) {
        Component focusable = FocusHelper.getFocusable(component);
        ApplicationInstance active = ApplicationInstance.getActive();
        if (active != null) {
            active.setFocusedComponent(focusable);
        }
        return focusable;
    }

    public static Component getFocus() {
        ApplicationInstance active = ApplicationInstance.getActive();
        return active != null ? active.getFocusedComponent() : null;
    }

    private static boolean isFocusable(Component component) {
        boolean result = false;
        if (component instanceof DelegateFocusSupport) {
            component = ((DelegateFocusSupport)component).getFocusComponent();
        }
        if (component.isEnabled() && component.isFocusTraversalParticipant()) {
            result = component instanceof TextComponent || component instanceof AbstractButton || component instanceof KeyTable || component instanceof ListBox || component instanceof SelectField || component instanceof DropDown || component instanceof ColorSelect && ((ColorSelect)component).isDisplayValue();
        }
        return result;
    }
}

