/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.factory;

import java.math.BigDecimal;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.text.Document;
import org.openvpms.web.echo.factory.ComponentFactory;
import org.openvpms.web.echo.text.PasswordField;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.echo.text.TextDocument;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.format.NumberFormatter;

public class TextComponentFactory
extends ComponentFactory {
    public static TextField create() {
        TextField text = new TextField((Document)new TextDocument());
        TextComponentFactory.setDefaultStyle((Component)text);
        return text;
    }

    public static TextField create(int columns) {
        TextField text = TextComponentFactory.create();
        if (columns <= 10) {
            text.setWidth(new Extent(columns, 64));
        } else {
            text.setWidth(new Extent(columns, 128));
        }
        TextComponentFactory.setDefaultStyle((Component)text);
        return text;
    }

    public static TextArea createTextArea() {
        TextArea text = new TextArea((Document)new TextDocument());
        TextComponentFactory.setDefaultStyle((Component)text);
        return text;
    }

    public static TextArea createTextArea(int columns, int rows) {
        TextArea text = new TextArea((Document)new TextDocument());
        text.setWidth(new Extent(columns, 128));
        text.setHeight(new Extent(rows, 64));
        TextComponentFactory.setDefaultStyle((Component)text);
        return text;
    }

    public static PasswordField createPassword() {
        PasswordField password = new PasswordField();
        password.setDocument((Document)new TextDocument());
        TextComponentFactory.setDefaultStyle((Component)password);
        return password;
    }

    public static TextComponent create(String value, int minLength, int maxLength) {
        int width;
        int columns;
        int n = columns = value != null ? value.length() : minLength;
        if (columns < minLength) {
            columns = minLength;
        }
        if (columns > maxLength) {
            columns = maxLength;
        }
        TextField result = TextComponentFactory.create();
        int units = 128;
        if (columns < 7) {
            width = columns;
            units = 64;
        } else {
            width = columns < 25 ? columns + 3 + columns / 5 : columns + columns / 8;
        }
        if (width > maxLength) {
            width = maxLength;
        }
        result.setWidth(new Extent(width, units));
        result.setText(value);
        return result;
    }

    public static PasswordField createPassword(int columns) {
        PasswordField text = TextComponentFactory.createPassword();
        if (columns <= 10) {
            text.setWidth(new Extent(columns, 64));
        } else {
            text.setWidth(new Extent(columns, 128));
        }
        return text;
    }

    public static TextComponent createAmount(BigDecimal amount, int columns, boolean readOnly) {
        TextField field = TextComponentFactory.create(columns);
        Alignment align = new Alignment(5, 0);
        field.setAlignment(align);
        field.setText(NumberFormatter.getCurrencyFormat().format(amount));
        if (readOnly) {
            field.setEnabled(false);
        }
        return field;
    }
}

