/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.button;

import nextapp.echo2.app.button.AbstractButton;
import nextapp.echo2.app.button.ButtonModel;
import nextapp.echo2.app.button.DefaultToggleButtonModel;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.web.echo.event.ActionListener;

public class ToggleButton
extends AbstractButton {
    private boolean selected = false;
    private String style = "default";
    private String pressedStyle = "pressed";

    public ToggleButton() {
        this.setStyleName(this.style);
        this.setModel((ButtonModel)new DefaultToggleButtonModel());
        this.addActionListener(new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                ToggleButton.this.setSelected(!ToggleButton.this.selected);
            }
        });
    }

    public ToggleButton(String text) {
        this(text, false);
    }

    public ToggleButton(String text, boolean selected) {
        this();
        this.setText(text);
        this.setSelected(selected);
    }

    public void setDefaultStyle(String styleName) {
        this.style = styleName;
        this.setSelected(this.selected);
    }

    public void setPressedStyle(String styleName) {
        this.pressedStyle = styleName;
        this.setSelected(this.selected);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.setStyleName(selected ? this.pressedStyle : this.style);
    }

    public boolean isSelected() {
        return this.selected;
    }
}

