/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.button;

import echopointng.KeyStrokeListener;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.button.AbstractButton;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.web.echo.button.ShortcutButton;
import org.openvpms.web.echo.button.ShortcutButtons;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.echo.keyboard.KeyStrokeHandler;

public class ButtonSet
implements KeyStrokeHandler {
    private final Component container;
    private final FocusGroup focusGroup;
    private final String style;
    private final ShortcutButtons buttons;
    private boolean hideDisabled;
    private static final String BUTTON_STYLE = "default";

    public ButtonSet(Component container) {
        this(container, null);
    }

    public ButtonSet(Component container, FocusGroup focus) {
        this(container, focus, BUTTON_STYLE);
    }

    public ButtonSet(Component container, FocusGroup focus, String style) {
        this(container, container, focus, style);
    }

    public ButtonSet(Component container, Component shortcutContainer, FocusGroup focus, String style) {
        this.container = container;
        if (focus != null) {
            this.focusGroup = new FocusGroup("ButtonSet");
            focus.add(this.focusGroup);
        } else {
            this.focusGroup = null;
        }
        this.buttons = new ShortcutButtons(shortcutContainer);
        this.style = style != null ? style : BUTTON_STYLE;
    }

    public Button add() {
        return this.add(null, false);
    }

    public Button add(String id) {
        return this.add(id, false);
    }

    public Button add(String id, boolean disableShortcut) {
        Button button = this.create(id, disableShortcut);
        return this.add(button);
    }

    public Button create(String id) {
        return this.create(id, false);
    }

    public Button create(String id, boolean disableShortcut) {
        return ButtonFactory.create(id, this.style, !disableShortcut);
    }

    public Button create(String id, final Runnable listener) {
        return this.create(id, new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                listener.run();
            }
        });
    }

    public Button create(String id, nextapp.echo2.app.event.ActionListener listener) {
        return this.create(id, false, listener);
    }

    public Button create(String id, boolean disableShortcut, nextapp.echo2.app.event.ActionListener listener) {
        Button button = this.create(id, disableShortcut);
        button.addActionListener(listener);
        return button;
    }

    public Button add(Button button) {
        return this.add(button, this.getNextIndex());
    }

    public RadioButton add(RadioButton button) {
        return this.add(button, this.getNextIndex());
    }

    public Button add(String id, int index) {
        Button button = this.create(id, false);
        return this.add(button, index);
    }

    public Button add(Button button, int index) {
        this.addButton((AbstractButton)button, index);
        return button;
    }

    public RadioButton add(RadioButton button, int index) {
        this.addButton((AbstractButton)button, index);
        return button;
    }

    public Button add(String id, final Runnable listener) {
        return this.add(id, new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                listener.run();
            }
        });
    }

    public Button add(String id, nextapp.echo2.app.event.ActionListener listener) {
        return this.add(id, false, listener);
    }

    public Button add(String id, boolean disableShortcut, final Runnable listener) {
        return this.add(id, disableShortcut, new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                listener.run();
            }
        });
    }

    public Button add(String id, boolean disableShortcut, nextapp.echo2.app.event.ActionListener listener) {
        Button button = this.add(id, disableShortcut);
        button.addActionListener(listener);
        return button;
    }

    public void remove(AbstractButton button) {
        if (button.getParent() != null && button.getParent().equals(this.container)) {
            this.container.remove((Component)button);
        }
        if (button instanceof ShortcutButton) {
            this.buttons.remove((ShortcutButton)button);
        }
    }

    public void remove(String id) {
        AbstractButton button = this.getButton(id);
        if (button != null) {
            this.remove(button);
        }
    }

    public void removeAll() {
        for (Component component : this.container.getComponents()) {
            if (!(component instanceof AbstractButton)) continue;
            this.remove((AbstractButton)component);
        }
    }

    public AbstractButton getButton(String id) {
        return (Button)this.container.getComponent(id);
    }

    public int indexOf(String id) {
        AbstractButton button = this.getButton(id);
        return button == null ? -1 : this.container.indexOf((Component)button);
    }

    public void setHideDisabled(boolean hide) {
        this.hideDisabled = hide;
    }

    public void setEnabled(String id, boolean enabled) {
        AbstractButton button = this.getButton(id);
        if (button != null) {
            button.setEnabled(enabled);
            if (this.hideDisabled) {
                button.setVisible(enabled);
            }
        }
    }

    public boolean isEnabled(String id) {
        AbstractButton button = this.getButton(id);
        return button != null && button.isEnabled();
    }

    public void setFocus(String id) {
        AbstractButton button = this.getButton(id);
        if (button != null) {
            FocusHelper.setFocus((Component)button);
        }
    }

    public void addKeyListener(int keyCode, final Runnable listener) {
        this.buttons.addListener(keyCode, new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                listener.run();
            }
        });
    }

    public void addKeyListener(int keyCode, nextapp.echo2.app.event.ActionListener listener) {
        this.buttons.addListener(keyCode, listener);
    }

    public void removeKeyListener(int keyCode) {
        this.buttons.removeListener(keyCode);
    }

    public Component getContainer() {
        return this.container;
    }

    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    @Override
    public void reregisterKeyStrokeListeners() {
        this.buttons.reregisterKeyStrokeListeners();
    }

    public ShortcutButtons getButtons() {
        return this.buttons;
    }

    private int getNextIndex() {
        KeyStrokeListener listener = this.buttons.getKeyStrokeListener();
        int index = listener != null ? this.container.indexOf((Component)listener) : this.container.getComponentCount();
        return index;
    }

    private void addButton(AbstractButton button, int index) {
        if (button instanceof ShortcutButton) {
            this.buttons.add((ShortcutButton)button);
        }
        if (this.focusGroup != null) {
            this.focusGroup.add((Component)button);
        }
        this.container.add((Component)button, index);
    }
}

