/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2016 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.echo.event;


/**
 * A VetoListener event gets fired whenever a vetoable action is performed.
 *
 * @author Tim Anderson
 * @see Vetoable
 */
public interface VetoListener<T extends Vetoable> extends java.util.EventListener {

    /**
     * Invoked when a vetoable action is performed.
     *
     * @param action the action to veto or allow
     */
    void onVeto(T action);

}
