/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.text;

import echopointng.ComponentEx;
import echopointng.KeyStrokeListener;
import echopointng.MutableStyleEx;
import echopointng.able.Attributeable;
import echopointng.able.Borderable;
import echopointng.able.Insetable;
import echopointng.able.MouseCursorable;
import echopointng.able.Sizeable;
import echopointng.richtext.RichTextSpellChecker;
import echopointng.util.ColorKit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.text.Document;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openvpms.web.echo.text.DefaultRichTextRenderer;
import org.openvpms.web.echo.text.MacroExpander;
import org.openvpms.web.echo.text.RichTextRenderer;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.echo.text.TextDocument;

public class RichTextArea
extends TextComponent
implements Sizeable,
Insetable,
MouseCursorable,
Borderable,
Attributeable {
    public static final Style DEFAULT_STYLE;
    public static final Color DEFAULT_TOOLBAR_BACKGROUND;
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_EDITOR_BACKGROUND = "editorBackground";
    public static final String PROPERTY_EDITOR_BORDER = "editorBorder";
    public static final String PROPERTY_EDITOR_FONT = "editorFont";
    public static final String PROPERTY_EDITOR_FOREGROUND = "editorForeground";
    public static final String PROPERTY_RENDERER = "renderer";
    public static final String PROPERTY_SPELL_CHECK_IN_PROGRESS = "spellCheckInProgress";
    public static final String PROPERTY_SPELL_CHECKER = "spellChecker";
    public static final String PROPERTY_TOOLBAR_ALIGNMENT = "toolBarAlignment";
    public static final String PROPERTY_TOOLBAR_BACKGROUND = "toolBarBackground";
    public static final String PROPERTY_MACRO_EXPANSION = "macro";
    private Map<String, Object> attributeMap;
    private MacroExpander macros;
    private KeyStrokeListener listener = new KeyStrokeListener();
    private String textPreUpdate;
    private boolean inProcessInput = false;

    public RichTextArea() {
        this(null, null, null);
    }

    public RichTextArea(Document document) {
        this(document, null, null, null);
    }

    public RichTextArea(Document document, String text, Extent width, Extent height) {
        super(document);
        this.setFocusTraversalParticipant(true);
        this.setRenderer(new DefaultRichTextRenderer());
        this.setDocument(document);
        if (text != null) {
            this.setText(text);
        }
        this.setWidth(width);
        this.setHeight(height);
        this.setSpellCheckInProgress(false);
        this.setSupportsCursorPosition(false);
    }

    public RichTextArea(Extent width, Extent height) {
        this(null, width, height);
    }

    public RichTextArea(String text) {
        this(text, null, null);
    }

    public RichTextArea(String text, Extent width, Extent height) {
        this((Document)new TextDocument(), text, width, height);
    }

    public Object getAttribute(String attributeName) {
        if (this.attributeMap != null) {
            return this.attributeMap.get(attributeName);
        }
        return null;
    }

    public String[] getAttributeNames() {
        if (this.attributeMap == null) {
            return new String[0];
        }
        int count = 0;
        String[] attributeNames = new String[this.attributeMap.keySet().size()];
        Iterator<String> iter = this.attributeMap.keySet().iterator();
        while (iter.hasNext()) {
            attributeNames[count++] = iter.next();
        }
        return attributeNames;
    }

    public Color getEditorBackground() {
        return (Color)this.getProperty(PROPERTY_EDITOR_BACKGROUND);
    }

    public Border getEditorBorder() {
        return (Border)this.getProperty(PROPERTY_EDITOR_BORDER);
    }

    public Font getEditorFont() {
        return (Font)this.getProperty(PROPERTY_EDITOR_FONT);
    }

    public Color getEditorForeground() {
        return (Color)this.getProperty(PROPERTY_EDITOR_FOREGROUND);
    }

    public int getMouseCursor() {
        return ComponentEx.getProperty((Component)this, (String)"mouseCursor", (int)0);
    }

    public String getMouseCursorUri() {
        return (String)this.getProperty("mouseCursorUri");
    }

    public Insets getOutsets() {
        return (Insets)this.getProperty("outsets");
    }

    public RichTextRenderer getRenderer() {
        return (RichTextRenderer)this.getProperty(PROPERTY_RENDERER);
    }

    public RichTextSpellChecker getSpellChecker() {
        return (RichTextSpellChecker)this.getProperty(PROPERTY_SPELL_CHECKER);
    }

    public int getToolBarAlignment() {
        return ComponentEx.getProperty((Component)this, (String)PROPERTY_TOOLBAR_ALIGNMENT, (int)6);
    }

    public Color getToolBarBackground() {
        return (Color)this.getProperty(PROPERTY_TOOLBAR_BACKGROUND);
    }

    public boolean isEditable() {
        return ComponentEx.getProperty((Component)this, (String)PROPERTY_EDITABLE, (boolean)true);
    }

    public boolean isSpellCheckInProgress() {
        return ComponentEx.getProperty((Component)this, (String)PROPERTY_SPELL_CHECK_IN_PROGRESS, (boolean)false);
    }

    @Override
    public void processInput(String inputName, Object inputValue) {
        try {
            this.inProcessInput = true;
            if ("keyStroke".equals(inputName)) {
                this.listener.processInput(inputName, inputValue);
            } else {
                if (inputValue != null && "text".equals(inputName)) {
                    inputValue = this.makeValidXHTML(new StringBuilder((String)inputValue));
                    this.textPreUpdate = (String)inputValue;
                }
                super.processInput(inputName, inputValue);
                if ("spellcheck".equals(inputName)) {
                    this.setSpellCheckInProgress(!this.isSpellCheckInProgress());
                } else if (PROPERTY_MACRO_EXPANSION.equals(inputName) && this.macros != null) {
                    this.insertMacro((String)inputValue);
                }
            }
        }
        finally {
            this.inProcessInput = false;
            this.textPreUpdate = null;
        }
    }

    public void insertMacro(String macro) {
        this.firePropertyChange(PROPERTY_MACRO_EXPANSION, null, this.expand(macro));
    }

    public void setMacroExpander(MacroExpander macros) {
        this.macros = macros;
    }

    public KeyStrokeListener getListener() {
        return this.listener;
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap<String, Object>();
        }
        this.attributeMap.put(attributeName, attributeValue);
    }

    public void setEditable(boolean newValue) {
        ComponentEx.setProperty((Component)this, (String)PROPERTY_EDITABLE, (boolean)newValue);
    }

    public void setEditorBackground(Color editorBackground) {
        this.setProperty(PROPERTY_EDITOR_BACKGROUND, editorBackground);
    }

    public void setEditorBorder(Border editorBorder) {
        this.setProperty(PROPERTY_EDITOR_BORDER, editorBorder);
    }

    public void setEditorFont(Font editorFont) {
        this.setProperty(PROPERTY_EDITOR_FONT, editorFont);
    }

    public void setEditorForeground(Color editorForeground) {
        this.setProperty(PROPERTY_EDITOR_FOREGROUND, editorForeground);
    }

    public void setMouseCursor(int mouseCursor) {
        ComponentEx.setProperty((Component)this, (String)"mouseCursor", (int)mouseCursor);
    }

    public void setMouseCursorUri(String mouseCursorURI) {
        this.setProperty("mouseCursorUri", mouseCursorURI);
    }

    public void setOutsets(Insets newValue) {
        this.setProperty("outsets", newValue);
    }

    public void setRenderer(RichTextRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException("The RichTextRenderer must be non null");
        }
        this.setProperty(PROPERTY_RENDERER, renderer);
    }

    public void setSpellChecker(RichTextSpellChecker spellChecker) {
        this.setProperty(PROPERTY_SPELL_CHECKER, spellChecker);
    }

    public void setSpellCheckInProgress(boolean spellCheckInProgress) {
        ComponentEx.setProperty((Component)this, (String)PROPERTY_SPELL_CHECK_IN_PROGRESS, (boolean)spellCheckInProgress);
    }

    public void setToolBarAlignment(int newValue) {
        if (newValue != 6 && newValue != 7) {
            throw new IllegalArgumentException("The toolbar alignment must be either Alignment.TOP or Alignment.BOTTOM");
        }
        ComponentEx.setProperty((Component)this, (String)PROPERTY_TOOLBAR_ALIGNMENT, (int)newValue);
    }

    public void setToolBarBackground(Color newValue) {
        this.setProperty(PROPERTY_TOOLBAR_BACKGROUND, newValue);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.inProcessInput && "text".equals(propertyName)) {
            if (!StringUtils.equals((CharSequence)this.textPreUpdate, (CharSequence)((String)newValue))) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        } else {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected String makeValidXHTML(StringBuilder buffer) {
        String[] tags;
        for (String tag : tags = new String[]{"<br", "<img", "<col", "<hr", "<input"}) {
            int index = buffer.indexOf(tag);
            while (index != -1) {
                int endindex = buffer.indexOf(">", index);
                String currentTag = buffer.substring(index, endindex + 1);
                currentTag = currentTag.substring(0, currentTag.length() - 1);
                currentTag = currentTag + "/>";
                buffer.replace(index, endindex + 1, currentTag);
                index = buffer.indexOf(tag, endindex + 1);
            }
        }
        return buffer.toString();
    }

    protected String expand(String macro) {
        String result = this.macros.expand(macro);
        if (!StringUtils.isEmpty((CharSequence)result)) {
            result = StringEscapeUtils.escapeHtml4((String)result);
            result = result.replace("\n", "<br/>").replace(" ", "&nbsp;");
        }
        return result;
    }

    static {
        DEFAULT_TOOLBAR_BACKGROUND = new Color(0xEFEFEF);
        MutableStyleEx style = new MutableStyleEx();
        style.setProperty("width", (Object)new Extent(620));
        style.setProperty("height", (Object)new Extent(200));
        style.setProperty("background", (Object)ColorKit.makeColor((int)0xEFEFDE));
        style.setProperty(PROPERTY_EDITOR_BACKGROUND, (Object)Color.WHITE);
        style.setProperty(PROPERTY_TOOLBAR_BACKGROUND, (Object)ColorKit.makeColor((int)0xEFEFDE));
        DEFAULT_STYLE = style;
    }
}

