/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.table;

import echopointng.LabelEx;
import echopointng.layout.TableLayoutDataEx;
import echopointng.xhtml.XhtmlFragment;
import java.util.Iterator;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.layout.TableLayoutData;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.web.echo.colour.ColourHelper;
import org.openvpms.web.echo.factory.LabelFactory;

public class TableHelper {
    public static final String SPACER = "<div>&#160;</div>";

    public static int getNextModelIndex(TableColumnModel model) {
        return TableHelper.getNextModelIndex(model, 0);
    }

    public static int getNextModelIndex(TableColumnModel model, int from) {
        int index = from + 1;
        Iterator iterator = model.getColumns();
        while (iterator.hasNext()) {
            TableColumn col = (TableColumn)iterator.next();
            if (col.getModelIndex() < index) continue;
            index = col.getModelIndex() + 1;
        }
        return index;
    }

    public static int getColumnOffset(TableColumnModel model, int column) {
        int result = -1;
        int offset = 0;
        Iterator iterator = model.getColumns();
        while (iterator.hasNext()) {
            TableColumn col = (TableColumn)iterator.next();
            if (col.getModelIndex() == column) {
                result = offset;
                break;
            }
            ++offset;
        }
        return result;
    }

    public static XhtmlFragment createFragment(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return new XhtmlFragment(SPACER);
        }
        text = StringEscapeUtils.escapeXml((String)text);
        return new XhtmlFragment("<p>" + text + "</p>");
    }

    public static XhtmlFragment createFragment(Object object) {
        return TableHelper.createFragment(object != null ? object.toString() : null);
    }

    public static Label createSpacer() {
        return new LabelEx(TableHelper.createFragment(null));
    }

    public static TableLayoutDataEx getTableLayoutDataEx(String styleName) {
        TableLayoutDataEx result = null;
        ApplicationInstance app = ApplicationInstance.getActive();
        Style style = app.getStyle(Component.class, styleName);
        if (style != null) {
            LayoutData layout = (LayoutData)style.getProperty("layoutData");
            if (layout instanceof TableLayoutDataEx) {
                result = (TableLayoutDataEx)layout;
            } else if (layout instanceof TableLayoutData) {
                result = new TableLayoutDataEx();
                TableHelper.mergeLayoutData((TableLayoutData)result, (TableLayoutData)layout, true);
            }
        }
        return result;
    }

    public static void mergeStyle(Component component, String styleName) {
        TableHelper.mergeStyle(component, styleName, false);
    }

    public static void mergeStyle(Component component, String styleName, boolean overwrite) {
        if (component.getLayoutData() == null && component.getStyleName() == null) {
            component.setStyleName(styleName);
        } else {
            ApplicationInstance app = ApplicationInstance.getActive();
            Style style = app.getStyle(component.getClass(), styleName);
            if (style != null) {
                TableHelper.mergeStyle(style, component, overwrite);
            }
        }
    }

    public static void mergeStyle(Component component, TableLayoutData layoutData, boolean overwrite) {
        if (component.getLayoutData() == null) {
            component.setLayoutData((LayoutData)new TableLayoutData());
        }
        TableHelper.mergeLayoutData((TableLayoutData)component.getLayoutData(), layoutData, overwrite);
    }

    public static void mergeStyle(TableLayoutData layout, String styleName) {
        LayoutData from;
        ApplicationInstance app = ApplicationInstance.getActive();
        Style style = app.getStyle(Component.class, styleName);
        if (style != null && (from = (LayoutData)style.getProperty("layoutData")) instanceof TableLayoutData) {
            TableHelper.mergeLayoutData(layout, (TableLayoutData)from, false);
        }
    }

    public static Label rightAlign(String text) {
        return TableHelper.align(text, new Alignment(5, 0));
    }

    public static Label centreAlign(String text) {
        return TableHelper.align(text, new Alignment(4, 0));
    }

    public static Label align(String text, Alignment alignment) {
        Label label = LabelFactory.create();
        label.setText(text);
        TableLayoutDataEx layout = new TableLayoutDataEx();
        layout.setAlignment(alignment);
        label.setLayoutData((LayoutData)layout);
        return label;
    }

    public static void setForeground(Component component, Color colour) {
        Color foreground = TableHelper.getForeground(component);
        if (foreground == null || !colour.equals((Object)foreground) && (foreground.equals((Object)Color.BLACK) || foreground.equals((Object)Color.WHITE))) {
            component.setForeground(colour);
        }
        for (Component child : component.getComponents()) {
            TableHelper.setForeground(child, colour);
        }
    }

    public static TableLayoutData alignRight() {
        return TableHelper.align(new Alignment(5, 0));
    }

    public static TableLayoutData alignTop() {
        return TableHelper.align(new Alignment(0, 6));
    }

    public static TableLayoutData align(Alignment alignment) {
        TableLayoutDataEx layout = new TableLayoutDataEx();
        layout.setAlignment(alignment);
        return layout;
    }

    private static void mergeStyle(Style style, Component component, boolean overwrite) {
        Iterator names = style.getPropertyNames();
        while (names.hasNext()) {
            Object value;
            String name = (String)names.next();
            if (name.equals("layoutData") && component.getLayoutData() != null) {
                TableLayoutData from = (TableLayoutData)style.getProperty(name);
                TableLayoutData to = (TableLayoutData)component.getLayoutData();
                if (to == null) continue;
                TableHelper.mergeLayoutData(to, from, overwrite);
                continue;
            }
            if (!overwrite && component.getProperty(name) != null || (value = style.getProperty(name)) == null) continue;
            try {
                Color background;
                BeanUtils.setProperty((Object)component, (String)name, (Object)value);
                if (!(value instanceof TableLayoutData) || (background = ((TableLayoutData)value).getBackground()) == null) continue;
                TableHelper.setForeground(component, ColourHelper.getTextColour(background));
            }
            catch (Throwable throwable) {}
        }
    }

    private static Color getForeground(Component component) {
        Color result = component.getForeground();
        if (result == null && component.getStyleName() != null) {
            Style style = ApplicationInstance.getActive().getStyle(component.getClass(), component.getStyleName());
            result = style != null ? (Color)style.getProperty("foreground") : null;
        }
        return result;
    }

    private static void mergeLayoutData(TableLayoutData to, TableLayoutData from, boolean overwrite) {
        if (from.getAlignment() != null && (overwrite || to.getAlignment() == null)) {
            to.setAlignment(from.getAlignment());
        }
        if (from.getBackground() != null && (overwrite || to.getBackground() == null)) {
            to.setBackground(from.getBackground());
        }
        if (from.getBackgroundImage() != null && (overwrite || to.getBackgroundImage() == null)) {
            to.setBackgroundImage(from.getBackgroundImage());
        }
        if (from.getInsets() != null && (overwrite || to.getInsets() == null)) {
            to.setInsets(from.getInsets());
        }
    }
}

