/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.table;

import java.util.EventListener;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.TableModel;
import org.openvpms.web.echo.table.PageListener;
import org.openvpms.web.echo.table.RenderTableModel;

public class KeyTable
extends Table {
    public static final String PROPERTY_SELECTION_BLUR_FOREGROUND = "selectionBlurForeground";
    public static final String PROPERTY_SELECTION_BLUR_BACKGROUND = "selectionBlurBackground";
    public static final String PROPERTY_SELECTION_BLUR_FONT = "selectionBlurFont";
    protected static final String PAGE_ACTION = "page";
    private static final String PROPERTY_HEADER_FIXED = "headerFixed";

    public Color getPropertySelectionBlurForeground() {
        return (Color)this.getProperty(PROPERTY_SELECTION_BLUR_FOREGROUND);
    }

    public void setSelectionBlurForeground(Color newValue) {
        this.setProperty(PROPERTY_SELECTION_BLUR_FOREGROUND, newValue);
    }

    public Color getPropertySelectionBlurBackground() {
        return (Color)this.getProperty(PROPERTY_SELECTION_BLUR_BACKGROUND);
    }

    public void setSelectionBlurBackground(Color newValue) {
        this.setProperty(PROPERTY_SELECTION_BLUR_BACKGROUND, newValue);
    }

    public Font getSelectionBlurFont() {
        return (Font)this.getProperty(PROPERTY_SELECTION_BLUR_FONT);
    }

    public void setSelectionBlurFont(Font newValue) {
        this.setProperty(PROPERTY_SELECTION_BLUR_FONT, newValue);
    }

    public void addPageListener(PageListener listener) {
        this.getEventListenerList().addListener(PageListener.class, (EventListener)((Object)listener));
    }

    public void removePageListener(PageListener listener) {
        this.getEventListenerList().removeListener(PageListener.class, (EventListener)((Object)listener));
    }

    public boolean hasPageListeners() {
        return this.getEventListenerList().getListenerCount(PageListener.class) != 0;
    }

    public void setHeaderFixed(boolean fixed) {
        this.setProperty(PROPERTY_HEADER_FIXED, fixed);
        this.invalidate();
    }

    public boolean isHeaderFixed() {
        Object property = this.getProperty(PROPERTY_HEADER_FIXED);
        return property instanceof Boolean && (Boolean)property != false;
    }

    public void processInput(String inputName, Object inputValue) {
        super.processInput(inputName, inputValue);
        if (PAGE_ACTION.equals(inputName) && inputValue instanceof String) {
            this.firePageEvent((String)inputValue);
        }
    }

    protected void doRender() {
        TableModel model = this.getModel();
        try {
            if (model instanceof RenderTableModel) {
                ((RenderTableModel)model).preRender();
            }
            super.doRender();
        }
        finally {
            if (model instanceof RenderTableModel) {
                ((RenderTableModel)model).postRender();
            }
        }
    }

    private void firePageEvent(String page) {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(PageListener.class);
        ActionEvent event = null;
        for (EventListener listener : listeners) {
            if (event == null) {
                event = new ActionEvent((Object)this, page);
            }
            ((PageListener)((Object)listener)).actionPerformed(event);
        }
    }
}

