/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.style;

import java.awt.Dimension;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.StyleSheet;
import org.openvpms.web.echo.style.AbstractStyleSheetCache;
import org.openvpms.web.echo.style.Style;
import org.openvpms.web.echo.style.StyleSheets;

public class UserStyleSheets
extends AbstractStyleSheetCache {
    private final StyleSheets cache;
    private boolean overrideCacheDefaults = false;
    private final WeakHashMap<ApplicationInstance, Style> styles = new WeakHashMap();

    public UserStyleSheets(StyleSheets cache) {
        this.cache = cache;
        this.setDefaultProperties(cache.getDefaultProperties());
    }

    public void setStyle(ApplicationInstance app, Style style) {
        this.styles.put(app, style);
    }

    public Style getStyle() {
        return this.styles.get(ApplicationInstance.getActive());
    }

    @Override
    public Style getStyle(Dimension size) {
        Style result = this.getCachedStyleSheet(size);
        if (result == null) {
            result = this.overrideCacheDefaults || this.hasResolution(size) ? super.getStyle(size) : this.cache.getStyle(size);
        }
        return result;
    }

    @Override
    public synchronized void setDefaultProperties(Map<String, String> properties) {
        super.setDefaultProperties(properties);
        this.overrideCacheDefaults = true;
        this.clearCache();
    }

    @Override
    public StyleSheet getStyleSheet(Map<String, String> properties) {
        return this.cache.getStyleSheet(properties);
    }

    public void setProperties(Map<String, String> properties, int width, int height) {
        Dimension size = new Dimension(width, height);
        this.addResolution(size, properties);
    }

    public void reset() {
        this.setDefaultProperties(this.cache.getDefaultProperties());
        this.overrideCacheDefaults = false;
        for (Dimension size : this.getResolutions()) {
            this.removeResolution(size);
        }
    }

    @Override
    public synchronized Dimension[] getResolutions() {
        Set<Dimension> overrides = this.getAllResolutions().keySet();
        HashSet<Dimension> resolutions = new HashSet<Dimension>(Arrays.asList(this.cache.getResolutions()));
        resolutions.addAll(overrides);
        return this.sortResolutions(resolutions);
    }

    @Override
    public synchronized Map<String, String> getResolution(Dimension size) {
        Map<String, String> result = super.getResolution(size);
        if (result == null) {
            result = this.cache.getResolution(size);
        }
        return result;
    }
}

