/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.style;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.MutableStyleSheet;
import nextapp.echo2.app.componentxml.ComponentXmlException;
import nextapp.echo2.app.componentxml.StyleSheetLoader;
import org.apache.commons.io.IOUtils;
import org.openvpms.web.echo.style.StyleSheetException;

public class StyleSheetTemplate {
    private final List<String> template;

    public StyleSheetTemplate(InputStream stream) throws IOException {
        this.template = IOUtils.readLines((InputStream)stream, (Charset)StandardCharsets.UTF_8);
    }

    public MutableStyleSheet getStyleSheet(Map<String, String> properties) {
        InputStream expanded = this.replaceTokens(properties);
        try {
            return (MutableStyleSheet)StyleSheetLoader.load((InputStream)expanded, (ClassLoader)StyleSheetTemplate.class.getClassLoader());
        }
        catch (ComponentXmlException exception) {
            throw new StyleSheetException(StyleSheetException.ErrorCode.InvalidStyleSheet, exception, new Object[0]);
        }
    }

    private InputStream replaceTokens(Map<String, String> properties) {
        StringBuilder buffer = new StringBuilder();
        for (int count = 0; count < this.template.size(); ++count) {
            int pos;
            String line = this.template.get(count);
            int prev = 0;
            while ((pos = line.indexOf("${", prev)) >= 0) {
                int index;
                if (pos > 0) {
                    buffer.append(line, prev, pos);
                }
                if ((index = line.indexOf(125, pos)) < 0) {
                    throw new StyleSheetException(StyleSheetException.ErrorCode.UnterminatedProperty, count + 1, pos + 1);
                }
                String name = line.substring(pos + 2, index);
                String property = this.getProperty(name, properties);
                buffer.append(property);
                try {
                    Integer.valueOf(property);
                    buffer.append("px");
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                prev = index + 1;
            }
            if (prev >= line.length()) continue;
            buffer.append(line.substring(prev));
        }
        return new ByteArrayInputStream(buffer.toString().getBytes());
    }

    private String getProperty(String name, Map<String, String> properties) {
        String result = properties.get(name);
        if (result == null) {
            throw new StyleSheetException(StyleSheetException.ErrorCode.UndefinedProperty, name);
        }
        return result;
    }
}

