/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.spring;

import java.util.concurrent.atomic.AtomicInteger;
import nextapp.echo2.app.ApplicationInstance;
import org.openvpms.web.echo.util.TaskQueues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class SpringApplicationInstance
extends ApplicationInstance {
    private final TaskQueues taskQueues = new TaskQueues(this);
    private ApplicationContext context;
    private boolean disposed = false;
    private static final AtomicInteger count = new AtomicInteger(0);
    private static final Logger log = LoggerFactory.getLogger(SpringApplicationInstance.class);

    public SpringApplicationInstance() {
        log.debug("Active applications: {}", (Object)count.incrementAndGet());
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    public ApplicationContext getApplicationContext() {
        return this.context;
    }

    public TaskQueues getTaskQueues() {
        return this.taskQueues;
    }

    public abstract void lock();

    public abstract void unlock();

    public synchronized void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            super.dispose();
            this.taskQueues.dispose();
            log.debug("Active applications: {}", (Object)count.decrementAndGet());
        }
    }
}

