/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.servlet;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.webcontainer.NewInstanceService;
import nextapp.echo2.webcontainer.WebContainerServlet;
import nextapp.echo2.webcontainer.WindowHtmlService;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.ServiceRegistry;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.service.CoreServices;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.web.echo.service.LaunchService;
import org.openvpms.web.echo.service.WindowService;
import org.openvpms.web.echo.servlet.SessionMonitor;
import org.openvpms.web.echo.spring.SpringApplicationInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringWebContainerServlet
extends WebContainerServlet {
    private transient ApplicationContext context;
    private transient SessionMonitor monitor;
    private String name;
    private final transient ThreadLocal<String> servletName = new ThreadLocal();
    private final transient ThreadLocal<Locale> locale = new ThreadLocal();
    private static final long serialVersionUID = 1L;
    private static final String NEXT_INSTANCE = "__EchoNextApplicationInstance";
    private static final Logger log = LoggerFactory.getLogger(SpringWebContainerServlet.class);

    public SpringWebContainerServlet() {
        ServiceRegistry serviceRegistry = WebRenderServlet.getServiceRegistry();
        serviceRegistry.remove(CoreServices.CLIENT_ENGINE);
        serviceRegistry.remove((Service)WindowHtmlService.INSTANCE);
        serviceRegistry.remove((Service)NewInstanceService.INSTANCE);
        serviceRegistry.add(WindowService.CLIENT_ENGINE);
        serviceRegistry.add((Service)WindowService.INSTANCE);
        serviceRegistry.add((Service)LaunchService.INSTANCE);
    }

    public void init() throws ServletException {
        super.init();
        this.name = this.getInitParameter("app-name");
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            throw new ServletException("init-param not specified: app-name");
        }
    }

    public ApplicationInstance newApplicationInstance() {
        ApplicationContext context = this.getContext();
        SpringApplicationInstance app = (SpringApplicationInstance)((Object)context.getBean(this.name));
        app.setApplicationContext(context);
        SessionMonitor monitor = this.getSessionMonitor();
        monitor.newApplication(app, WebRenderServlet.getActiveConnection().getRequest().getSession());
        Locale current = this.locale.get();
        if (current != null) {
            app.setLocale(current);
        }
        return app;
    }

    public String getServletName() {
        return this.servletName.get();
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.processRequest(request, response);
        }
        catch (IOException | ServletException exception) {
            log.error(exception.getMessage(), exception);
            throw exception;
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
            throw new ServletException(exception);
        }
        finally {
            this.servletName.remove();
            this.locale.remove();
        }
    }

    protected boolean supportsMultipleInstances(HttpServletRequest request) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        String serviceId = request.getParameter("serviceId");
        boolean active = false;
        if ("Echo.AsyncMonitor".equals(serviceId) || "Echo.Synchronize".equals(serviceId)) {
            String value = request.getParameter("active");
            if (Boolean.parseBoolean(value)) {
                active = true;
            }
        } else {
            active = true;
        }
        if (active) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            this.getSessionMonitor().active(request, authentication);
        }
        if (this.supportsMultipleInstances(request)) {
            ServletInstance instance;
            Integer nextInstance = (Integer)session.getAttribute(NEXT_INSTANCE);
            if (nextInstance == null) {
                nextInstance = 1;
            }
            if ((instance = new ServletInstance(request)).getId() != -1 && instance.getId() < nextInstance) {
                this.servletName.set(instance.getServletName());
                this.locale.set(request.getLocale());
                super.process(request, response);
            } else {
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    nextInstance = (Integer)session.getAttribute(NEXT_INSTANCE);
                    if (nextInstance == null) {
                        nextInstance = 1;
                    }
                    instance.setId(nextInstance);
                    nextInstance = nextInstance + 1;
                    session.setAttribute(NEXT_INSTANCE, (Object)nextInstance);
                }
                this.servletName.set(instance.getServletName());
                String url = instance.getURI();
                String queryString = request.getQueryString();
                if (queryString != null) {
                    url = url + "?" + queryString;
                }
                response.sendRedirect(response.encodeRedirectURL(url));
            }
        } else {
            this.servletName.set(request.getServletPath());
            super.process(request, response);
        }
    }

    private synchronized SessionMonitor getSessionMonitor() {
        if (this.monitor == null) {
            this.monitor = (SessionMonitor)this.getContext().getBean(SessionMonitor.class);
        }
        return this.monitor;
    }

    private synchronized ApplicationContext getContext() {
        if (this.context == null) {
            this.context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        }
        return this.context;
    }

    private static class ServletInstance {
        String path;
        String uri;
        int id = -1;

        ServletInstance(HttpServletRequest request) {
            String tmp = request.getRequestURI();
            int index = tmp.indexOf(";");
            if (index != -1) {
                tmp = tmp.substring(0, index);
            }
            this.path = request.getServletPath();
            this.uri = tmp.substring(0, tmp.indexOf(this.path, 1) + this.path.length());
            if (this.uri.length() != tmp.length()) {
                try {
                    this.id = Integer.parseInt(tmp.substring(this.uri.length() + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        String getURI() {
            return this.uri + "/" + this.id;
        }

        String getServletName() {
            return this.path + "/" + this.id;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

