/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.servlet;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ContentType;
import nextapp.echo2.webrender.WebRenderServlet;

public class ServletHelper {
    public static boolean isEchoRequest(HttpServletRequest request) {
        String query = request.getQueryString();
        return query != null && query.contains("service");
    }

    public static String getServerURL() {
        HttpServletRequest request = ServletHelper.getRequest();
        return request != null ? ServletHelper.getServerURL(request) : null;
    }

    public static String getServerURL(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        url = url.substring(0, url.length() - request.getRequestURI().length());
        return url;
    }

    public static String getContextURL() {
        String url = null;
        HttpServletRequest request = ServletHelper.getRequest();
        if (request != null) {
            url = ServletHelper.getServerURL() + request.getContextPath();
        }
        return url;
    }

    public static String getRedirectURI(String servlet) {
        HttpServletRequest request = ServletHelper.getRequest();
        return request != null ? ServletHelper.getRedirectURI(request, servlet) : servlet;
    }

    public static String getRedirectURI(HttpServletRequest request, String servlet) {
        String uri;
        int start = (uri = request.getRequestURI()).startsWith("/") ? 1 : 0;
        int index = uri.indexOf("/", start);
        if (index != -1) {
            return uri.substring(0, index + 1) + servlet;
        }
        return uri + "/" + servlet;
    }

    public static HttpServletRequest getRequest() {
        Connection connection = WebRenderServlet.getActiveConnection();
        return connection != null ? connection.getRequest() : null;
    }

    public static int getApplicationInstanceCount(String servlet) {
        String instance = "Echo2UserInstance:/" + servlet;
        int count = 0;
        HttpServletRequest request = ServletHelper.getRequest();
        if (request != null) {
            HttpSession session = request.getSession();
            Enumeration attributes = session.getAttributeNames();
            while (attributes.hasMoreElements()) {
                String name = (String)attributes.nextElement();
                if (!name.startsWith(instance) || !(session.getAttribute(name) instanceof ContainerInstance)) continue;
                ++count;
            }
        }
        return count;
    }

    public static void forceExpiry(HttpServletResponse response) throws IOException {
        response.setContentType(ContentType.TEXT_HTML.getMimeType());
        response.setStatus(400);
        response.getWriter().write("Session Expired");
        response.flushBuffer();
    }
}

