/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.lightbox;

import echopointng.ComponentEx;
import echopointng.EPNG;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.RenderingContext;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;

public class LightBoxPeer
extends echopointng.ui.syncpeer.LightBoxPeer {
    private static final Service LIGHT_BOX_SERVICE = JavaScriptService.forResource((String)"EPNG.LightBox", (String)"/org/openvpms/web/echo/js/lightbox.js");

    public LightBoxPeer() {
        this.partialUpdateManager.add("zIndex", new PartialUpdateParticipant(){

            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }

            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                LightBoxPeer.this.renderZIndexDirective(rc, update.getParent());
            }
        });
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(LB_SERVICE.getId());
        this.renderInitDirective(new RenderingContext(rc, update, component), targetId, component);
    }

    private void renderInitDirective(RenderingContext rc, String containerId, Component component) {
        Style fallbackStyle = EPNG.getFallBackStyle((Component)component);
        String elementId = ContainerInstance.getElementId((Component)component);
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.appendPartDirective("update", "EPLightBox.MessageProcessor", "init");
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemizedUpdateElement.appendChild(itemElement);
        itemElement.setAttribute("eid", elementId);
        itemElement.setAttribute("container-eid", containerId);
        itemElement.setAttribute("hidden", String.valueOf(rc.getRP("hidden", fallbackStyle, false)));
        itemElement.setAttribute("enabled", String.valueOf(component.isRenderEnabled()));
        itemElement.setAttribute("zIndex", String.valueOf(rc.getRP("zIndex", -1)));
        ImageReference translucentImage = (ImageReference)rc.getRP("translucentImage", fallbackStyle);
        if (translucentImage != null) {
            itemElement.setAttribute("translucentImage", ImageManager.getURI((RenderContext)rc, (ImageReference)translucentImage));
        }
    }

    private void renderZIndexDirective(RenderContext rc, Component component) {
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPLightBox.MessageProcessor", "zIndex", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemizedUpdateElement.appendChild(itemElement);
        itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)component));
        int zIndex = ComponentEx.getRenderProperty((Component)component, (String)"zIndex", (int)-1);
        itemElement.setAttribute("zIndex", String.valueOf(zIndex));
    }

    static {
        WebRenderServlet.getServiceRegistry().remove(LB_SERVICE);
        WebRenderServlet.getServiceRegistry().add(LIGHT_BOX_SERVICE);
    }
}

