/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.dialog;

import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.button.ButtonGroup;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.web.echo.dialog.MessageDialog;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;

public class OptionDialog
extends MessageDialog {
    private final RadioButton[] options;
    private boolean closeOnSelection = false;
    private final ActionListener listener = new ActionListener(){

        @Override
        public void onAction(ActionEvent event) {
            OptionDialog.this.onSelected();
        }
    };

    public OptionDialog(String title, String message, String[] options) {
        this(title, message, options, (HelpContext)null);
    }

    public OptionDialog(String title, String message, String[] options, String[] buttons) {
        this(title, message, options, buttons, null);
    }

    public OptionDialog(String title, String message, String[] options, HelpContext help) {
        this(title, message, options, OK_CANCEL, help);
    }

    public OptionDialog(String title, String message, String[] options, String[] buttons, HelpContext help) {
        super(title, message, buttons, help);
        ButtonGroup group = new ButtonGroup();
        this.options = new RadioButton[options.length];
        for (int i = 0; i < this.options.length; ++i) {
            RadioButton button = ButtonFactory.create(null, group);
            button.setText(options[i]);
            group.addButton(button);
            this.options[i] = button;
        }
    }

    public void setSelected(int selected) {
        if (selected >= 0 && selected < this.options.length) {
            this.options[selected].setSelected(true);
        } else {
            for (RadioButton button : this.options) {
                button.setSelected(false);
            }
        }
    }

    public int getSelected() {
        int selected = -1;
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.options[i].isSelected()) continue;
            selected = i;
            break;
        }
        return selected;
    }

    public void setCloseOnSelection(boolean close) {
        if (close != this.closeOnSelection) {
            this.closeOnSelection = close;
            for (RadioButton option : this.options) {
                if (close) {
                    option.addActionListener((nextapp.echo2.app.event.ActionListener)this.listener);
                    continue;
                }
                option.removeActionListener((nextapp.echo2.app.event.ActionListener)this.listener);
            }
        }
    }

    @Override
    protected void onOK() {
        if (this.getSelected() != -1) {
            super.onOK();
        }
    }

    @Override
    protected void doLayout() {
        Label message = LabelFactory.create(true, true);
        message.setText(this.getMessage());
        Column column = ColumnFactory.create("WideCellSpacing", new Component[]{message});
        for (RadioButton button : this.options) {
            column.add((Component)button);
        }
        this.getLayout().add((Component)ColumnFactory.create("Inset.Large", new Component[]{column}));
    }

    private void onSelected() {
        if (this.closeOnSelection) {
            this.onOK();
        }
    }
}

