/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.button;

import org.apache.commons.lang.StringEscapeUtils;

public class ShortcutHelper {
    static final String UNDERLINE_OPEN = "<span xmlns=\"http://www.w3.org/1999/xhtml\" style=\"text-decoration:underline\">";
    static final String UNDERLINE_CLOSE = "</span>";

    public static String getShortcut(String text) {
        if (text == null) {
            return null;
        }
        String result = null;
        int index = 0;
        while ((index = text.indexOf("&", index)) != -1) {
            int keyIndex = index + 1;
            if (keyIndex < text.length()) {
                if (text.charAt(keyIndex) != '&') {
                    result = Character.toString(text.charAt(keyIndex));
                    break;
                }
                ++index;
            }
            ++index;
        }
        return result;
    }

    public static String getText(String text) {
        int index;
        if (text == null) {
            return "";
        }
        int lastIndex = 0;
        StringBuffer buf = new StringBuffer();
        while ((index = text.indexOf("&", lastIndex)) != -1) {
            int keyIndex = index + 1;
            if (keyIndex < text.length()) {
                if (text.charAt(keyIndex) == '&') {
                    index = keyIndex;
                }
                buf.append(text.substring(lastIndex, index));
            }
            lastIndex = index + 1;
        }
        buf.append(text.substring(lastIndex));
        return buf.toString();
    }

    public static String getHTML(String text) {
        int index;
        if (text == null) {
            return "";
        }
        int lastIndex = 0;
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        while ((index = text.indexOf("&", lastIndex)) != -1) {
            int keyIndex = index + 1;
            if (keyIndex < text.length()) {
                if (text.charAt(keyIndex) == '&') {
                    index = keyIndex;
                    buf.append(StringEscapeUtils.escapeXml((String)text.substring(lastIndex, index)));
                } else {
                    buf.append(StringEscapeUtils.escapeXml((String)text.substring(lastIndex, index)));
                    if (first) {
                        buf.append(UNDERLINE_OPEN);
                        buf.append(StringEscapeUtils.escapeXml((String)text.substring(keyIndex, keyIndex + 1)));
                        buf.append(UNDERLINE_CLOSE);
                        first = false;
                    } else {
                        buf.append(StringEscapeUtils.escapeXml((String)text.substring(keyIndex, keyIndex + 1)));
                    }
                }
                index = keyIndex;
            }
            lastIndex = index + 1;
        }
        buf.append(StringEscapeUtils.escapeXml((String)text.substring(lastIndex)));
        return buf.toString();
    }
}

