/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.button;

import echopointng.ButtonEx;
import echopointng.ui.syncpeer.PushButtonPeer;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.RenderingContext;
import echopointng.ui.util.TriCellTable;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Style;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.propertyrender.AlignmentRender;
import nextapp.echo2.webrender.output.CssStyle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class AccessKeyButtonPeer
extends PushButtonPeer {
    protected void renderButtonContent(RenderingContext rc, Element buttonContainerElement, ButtonEx button, Style fallbackStyle) {
        Node contentNode;
        Element iconElement;
        String elementId = ContainerInstance.getElementId((Component)button);
        ImageReference icon = (ImageReference)rc.getRP(button.isRenderEnabled() ? "icon" : "disabledIcon", fallbackStyle);
        Node textNode = this.getTextNode(rc, button, fallbackStyle);
        if (icon == null) {
            iconElement = null;
        } else {
            iconElement = ImageManager.createImgE((RenderContext)rc, (ImageReference)icon);
            iconElement.setAttribute("id", elementId + "_icon");
        }
        int entityCount = (textNode == null ? 0 : 1) + (iconElement == null ? 0 : 1);
        switch (entityCount) {
            case 1: {
                if (textNode != null) {
                    contentNode = textNode;
                    break;
                }
                contentNode = iconElement;
                break;
            }
            case 2: {
                Extent iconTextMargin = (Extent)rc.getRP("iconTextMargin", fallbackStyle);
                Alignment textPosition = (Alignment)rc.getRP("textPosition", fallbackStyle);
                int orientation = this.convertIconTextPositionToOrientation(textPosition, (Component)button);
                TriCellTable tct = new TriCellTable(rc.getDocument(), elementId, orientation, iconTextMargin);
                this.renderCellText(rc, tct, textNode, button, fallbackStyle);
                this.renderCellIcon(rc, tct, iconElement, 1, fallbackStyle);
                Element tableElement = tct.getTableElement();
                tableElement.setAttribute("id", elementId + "_table");
                contentNode = tableElement;
                break;
            }
            default: {
                contentNode = null;
            }
        }
        if (contentNode != null) {
            buttonContainerElement.appendChild(contentNode);
        }
    }

    protected Node getTextNode(RenderingContext rc, ButtonEx button, Style fallbackStyle) {
        Node textNode;
        String text = (String)rc.getRP("text", fallbackStyle);
        if (text != null) {
            int pos;
            Document document = rc.getDocument();
            if (button.getAccessKey() != null && (pos = text.indexOf(button.getAccessKey())) != -1) {
                Element span = document.createElement("span");
                if (pos != 0) {
                    Text first = document.createTextNode(text.substring(0, pos));
                    span.appendChild(first);
                }
                Element underlined = document.createElement("span");
                underlined.setAttribute("style", "text-decoration:underline");
                underlined.appendChild(document.createTextNode(text.substring(pos, pos + 1)));
                span.appendChild(underlined);
                if (pos + 1 < text.length()) {
                    Text last = document.createTextNode(text.substring(pos + 1));
                    span.appendChild(last);
                }
                textNode = span;
            } else {
                textNode = document.createTextNode(text);
            }
        } else {
            textNode = null;
        }
        return textNode;
    }

    protected void renderCellText(RenderingContext rc, TriCellTable tct, Node textNode, ButtonEx button, Style fallbackStyle) {
        Element textTdElement = tct.getTdElement(0);
        CssStyle textTdCssStyle = new CssStyle();
        textTdCssStyle.setAttribute("padding", "0px");
        AlignmentRender.renderToStyle((CssStyle)textTdCssStyle, (Alignment)((Alignment)rc.getRP("textAlignment", fallbackStyle)));
        if (!rc.getRP("lineWrap", fallbackStyle, false)) {
            textTdCssStyle.setAttribute("white-space", "nowrap");
        }
        textTdElement.setAttribute("style", textTdCssStyle.renderInline());
        textTdElement.appendChild(textNode);
    }
}

