/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.web.component.property.AbstractPropertyTest;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;

public class SimplePropertyTestCase
extends AbstractPropertyTest {
    @Override
    @Test
    public void testGetDescriptor() {
        Property property = this.createStringProperty("Foo");
        Assert.assertNull((Object)property.getDescriptor());
    }

    @Override
    public void testDisplayName() {
        SimpleProperty property = new SimpleProperty("foo", String.class);
        Assert.assertEquals((Object)"Foo", (Object)property.getDisplayName());
        property.setDisplayName("bar");
        Assert.assertEquals((Object)"bar", (Object)property.getDisplayName());
    }

    @Override
    @Test
    public void testDescription() {
        SimpleProperty property = new SimpleProperty("foo", String.class);
        Assert.assertNull((Object)property.getDescription());
        property.setDescription("bar");
        Assert.assertEquals((Object)"bar", (Object)property.getDescription());
    }

    @Override
    public void testIsLookup() {
        SimpleProperty property = new SimpleProperty("foo", String.class);
        Assert.assertFalse((boolean)property.isLookup());
    }

    @Override
    public void testIsCollection() {
        SimpleProperty property = new SimpleProperty("foo", Map.class);
        Assert.assertFalse((boolean)property.isCollection());
    }

    @Override
    public void testGetArchetypeRange() {
        SimpleProperty property = new SimpleProperty("foo", String.class);
        Assert.assertEquals((long)0L, (long)property.getArchetypeRange().length);
        property.setArchetypeRange(new String[]{"party.patientpet"});
        Assert.assertEquals((long)1L, (long)property.getArchetypeRange().length);
        Assert.assertEquals((Object)"party.patientpet", (Object)property.getArchetypeRange()[0]);
        property.setArchetypeRange(new String[]{"act.customerAccountCharges*"});
        List<String> values = Arrays.asList(property.getArchetypeRange());
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("act.customerAccountChargesInvoice"));
        Assert.assertTrue((boolean)values.contains("act.customerAccountChargesCredit"));
        Assert.assertTrue((boolean)values.contains("act.customerAccountChargesCounter"));
    }

    @Override
    public void testIsDerived() {
        SimpleProperty property = new SimpleProperty("foo", String.class);
        Assert.assertFalse((boolean)property.isDerived());
    }

    @Override
    public void testIsReadOnly() {
        SimpleProperty property = new SimpleProperty("foo", String.class);
        Assert.assertFalse((boolean)property.isReadOnly());
        property.setReadOnly(true);
        Assert.assertTrue((boolean)property.isReadOnly());
    }

    @Override
    @Test
    public void testIsHidden() {
        SimpleProperty property = new SimpleProperty("foo", String.class);
        Assert.assertFalse((boolean)property.isHidden());
        property.setHidden(true);
        Assert.assertTrue((boolean)property.isHidden());
    }

    @Override
    @Test
    public void testIsRequired() {
        SimpleProperty property = new SimpleProperty("foo", String.class);
        Assert.assertFalse((boolean)property.isRequired());
        property.setRequired(true);
        Assert.assertTrue((boolean)property.isRequired());
    }

    @Override
    protected void checkValidationError(Property property, String message) {
        String expected = ValidatorError.format((String)property.getDisplayName(), (String)message);
        super.checkValidationError(property, expected);
    }

    @Override
    protected Property createBooleanProperty(String name) {
        return new SimpleProperty(name, Boolean.class);
    }

    @Override
    protected Property createStringProperty(String name, int minLength, int maxLength) {
        SimpleProperty result = new SimpleProperty(name, String.class);
        result.setMinLength(minLength);
        result.setMaxLength(maxLength);
        return result;
    }

    @Override
    protected Property createProperty(String name, Class type) {
        return new SimpleProperty(name, type);
    }

    @Override
    protected AbstractPropertyTest.TestProperty createTestProperty(int minLength, int maxLength) {
        SimpleTestProperty result = new SimpleTestProperty("foo", String.class);
        result.setMinLength(minLength);
        result.setMaxLength(maxLength);
        return result;
    }

    private class SimpleTestProperty
    extends SimpleProperty
    implements AbstractPropertyTest.TestProperty {
        private int count;

        public SimpleTestProperty(String name, Class type) {
            super(name, type);
            this.count = 0;
        }

        protected boolean doValidation(Validator validator) {
            ++this.count;
            return super.doValidation(validator);
        }

        @Override
        public int getValidations() {
            return this.count;
        }
    }
}

