/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.util.Date;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.web.component.property.DateTimePropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyTransformer;
import org.openvpms.web.component.property.SimpleProperty;

public class DateTimePropertyTransformerTestCase {
    @Test
    public void setTestDate() {
        SimpleProperty property = new SimpleProperty("date", Date.class);
        DateTimePropertyTransformer transformer = new DateTimePropertyTransformer((Property)property);
        property.setTransformer((PropertyTransformer)transformer);
        Assert.assertNull((Object)property.getValue());
        Date date = TestHelper.getDate((String)"1992-02-23");
        Assert.assertTrue((boolean)property.setValue((Object)date));
        Assert.assertEquals((Object)date, (Object)property.getValue());
        Date timestamp1 = TestHelper.getDatetime((String)"1980-01-01 12:39:38");
        Assert.assertTrue((boolean)property.setValue((Object)timestamp1));
        Assert.assertEquals((Object)timestamp1, (Object)property.getValue());
        Date timestamp2 = TestHelper.getDatetime((String)"1980-01-01 12:39:40");
        transformer.setKeepSeconds(false);
        property.setValue((Object)timestamp2);
        Assert.assertEquals((Object)TestHelper.getDatetime((String)"1980-01-01 12:39:00"), (Object)property.getValue());
    }

    @Test
    public void testSetString() {
        Locale.setDefault(new Locale("en", "AU"));
        SimpleProperty property = new SimpleProperty("date", Date.class);
        property.setTransformer((PropertyTransformer)new DateTimePropertyTransformer((Property)property));
        Assert.assertNull((Object)property.getValue());
        Assert.assertFalse((boolean)property.setValue((Object)"31/1/1970"));
        Assert.assertNull((Object)property.getValue());
        Assert.assertTrue((boolean)property.setValue((Object)"10:30"));
        Date expected1 = TestHelper.getDatetime((String)"1970-01-01 10:30:00");
        Assert.assertEquals((Object)expected1, (Object)property.getValue());
        Date date = TestHelper.getDate((String)"2010-01-01");
        Assert.assertTrue((boolean)property.setValue((Object)date));
        Assert.assertEquals((Object)date, (Object)property.getValue());
        Assert.assertTrue((boolean)property.setValue((Object)"12:30"));
        Date expected2 = TestHelper.getDatetime((String)"2010-01-01 12:30:00");
        Assert.assertEquals((Object)expected2, (Object)property.getValue());
        Assert.assertTrue((boolean)property.setValue((Object)""));
        Assert.assertNull((Object)property.getValue());
    }

    @Test
    public void testDateRange() {
        SimpleProperty property = new SimpleProperty("date", Date.class);
        Date min = TestHelper.getDate((String)"2003-08-01");
        Date max = TestHelper.getDate((String)"2003-09-01");
        property.setTransformer((PropertyTransformer)new DateTimePropertyTransformer((Property)property, min, max));
        Assert.assertFalse((boolean)property.setValue((Object)TestHelper.getDatetime((String)"2003-07-31 23:59:59")));
        Assert.assertTrue((boolean)property.setValue((Object)min));
        Assert.assertFalse((boolean)property.setValue((Object)TestHelper.getDate((String)"2003-09-02")));
        Assert.assertFalse((boolean)property.setValue((Object)max));
        Assert.assertTrue((boolean)property.setValue((Object)TestHelper.getDatetime((String)"2003-08-31 23:59:59")));
        Assert.assertTrue((boolean)property.setValue((Object)"10:30"));
        Assert.assertTrue((boolean)property.setValue((Object)"23:59:59"));
        Assert.assertTrue((boolean)property.setValue((Object)"00:00"));
    }

    @Before
    public void setUp() {
        Locale.setDefault(new Locale("en", "AU"));
    }
}

