/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.util.Date;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.web.component.property.DatePropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyTransformer;
import org.openvpms.web.component.property.SimpleProperty;

public class DatePropertyTransformerTestCase {
    @Test
    public void setTestDate() {
        SimpleProperty property = new SimpleProperty("date", Date.class);
        DatePropertyTransformer transformer = new DatePropertyTransformer((Property)property);
        property.setTransformer((PropertyTransformer)transformer);
        Assert.assertNull((Object)property.getValue());
        Date date = TestHelper.getDate((String)"1992-02-23");
        Assert.assertTrue((boolean)property.setValue((Object)date));
        Assert.assertEquals((Object)date, (Object)property.getValue());
        Date timestamp1 = TestHelper.getDatetime((String)"1980-01-01 12:39:38");
        Assert.assertTrue((boolean)property.setValue((Object)timestamp1));
        Assert.assertEquals((Object)timestamp1, (Object)property.getValue());
        Date timestamp2 = TestHelper.getDatetime((String)"1980-01-01 12:39:40");
        transformer.setKeepSeconds(false);
        property.setValue((Object)timestamp2);
        Assert.assertEquals((Object)TestHelper.getDatetime((String)"1980-01-01 12:39:00"), (Object)property.getValue());
    }

    @Test
    public void testSetString() {
        Locale.setDefault(new Locale("en", "AU"));
        SimpleProperty property = new SimpleProperty("date", Date.class);
        property.setTransformer((PropertyTransformer)new DatePropertyTransformer((Property)property));
        Assert.assertNull((Object)property.getValue());
        Assert.assertTrue((boolean)property.setValue((Object)"31/1/1970"));
        Object value = property.getValue();
        Date expected = TestHelper.getDate((String)"1970-01-31");
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertTrue((boolean)property.setValue((Object)""));
        Assert.assertNull((Object)property.getValue());
    }

    @Test
    public void testDateRange() {
        SimpleProperty property = new SimpleProperty("date", Date.class);
        Date min = TestHelper.getDate((String)"2003-08-01");
        Date max = TestHelper.getDate((String)"2003-09-01");
        property.setTransformer((PropertyTransformer)new DatePropertyTransformer((Property)property, min, max));
        Assert.assertFalse((boolean)property.setValue((Object)TestHelper.getDate((String)"2003-07-31")));
        Assert.assertTrue((boolean)property.setValue((Object)min));
        Assert.assertFalse((boolean)property.setValue((Object)TestHelper.getDate((String)"2003-09-02")));
        Assert.assertFalse((boolean)property.setValue((Object)max));
        Assert.assertTrue((boolean)property.setValue((Object)TestHelper.getDate((String)"2003-08-31")));
        Assert.assertFalse((boolean)property.setValue((Object)"31/07/2003"));
        Assert.assertTrue((boolean)property.setValue((Object)"01/08/2003"));
        Assert.assertFalse((boolean)property.setValue((Object)"02/09/2003"));
        Assert.assertTrue((boolean)property.setValue((Object)"31/8/2003"));
        Assert.assertFalse((boolean)property.setValue((Object)"01/09/2003"));
    }

    @Before
    public void setUp() {
        Locale.setDefault(new Locale("en", "AU"));
    }
}

