/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.party.TestContactFactory;
import org.openvpms.archetype.test.builder.party.TestEmailContactBuilder;
import org.openvpms.component.model.party.Contact;
import org.openvpms.web.component.mail.AddressFormatter;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAddressFormatterTest
extends ArchetypeServiceTest {
    @Autowired
    protected TestContactFactory contactFactory;
    @Autowired
    protected TestCustomerFactory customerFactory;
    private AddressFormatter formatter;
    private Contact email;

    @Before
    public void setUp() {
        this.formatter = this.createAddressFormatter();
        this.email = this.contactFactory.createEmail("foo@bar.com", new String[0]);
        ((TestCustomerBuilder)this.customerFactory.newCustomer().title("MR").name("Foo", "Bar").addContact(this.email)).build(false);
    }

    @Test
    public void testGetAddress() {
        Assert.assertNull((Object)this.formatter.getAddress(null));
        Assert.assertEquals((Object)"foo@bar.com", (Object)this.formatter.getAddress(this.email));
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)"Bar,Foo", (Object)this.formatter.getName(this.email));
        this.email.setName("Foo Bar");
        Assert.assertEquals((Object)"Foo Bar", (Object)this.formatter.getName(this.email));
    }

    @Test
    public void testGetQualifiedName() {
        Assert.assertEquals((Object)"Bar,Foo", (Object)this.formatter.getQualifiedName(this.email));
        this.email.setName("Foo Bar");
        Assert.assertEquals((Object)"Foo Bar (Bar,Foo)", (Object)this.formatter.getQualifiedName(this.email));
    }

    @Test
    public void testGetNameAddress() {
        Assert.assertEquals((Object)"Bar,Foo <foo@bar.com>", (Object)this.formatter.getNameAddress(this.email, false));
        Assert.assertEquals((Object)"\"Bar,Foo\" <foo@bar.com>", (Object)this.formatter.getNameAddress(this.email, true));
        this.email.setName("Foo Bar");
        Assert.assertEquals((Object)"Foo Bar <foo@bar.com>", (Object)this.formatter.getNameAddress(this.email, false));
        Assert.assertEquals((Object)"\"Foo Bar\" <foo@bar.com>", (Object)this.formatter.getNameAddress(this.email, true));
    }

    @Test
    public void testFormat() {
        Assert.assertEquals((Object)"Bar,Foo <foo@bar.com> - Customer", (Object)this.formatter.format(this.email));
        this.email.setName("Foo Bar");
        Assert.assertEquals((Object)"Foo Bar (Bar,Foo) <foo@bar.com> - Customer", (Object)this.formatter.format(this.email));
    }

    @Test
    public void testGetType() {
        Assert.assertEquals((Object)"Customer", (Object)this.formatter.getType(this.email));
    }

    @Test
    public void testWhitespace() {
        Contact contact = ((TestEmailContactBuilder)this.contactFactory.newEmail().name(" Bar ")).email("foo@bar.com").build();
        ((TestCustomerBuilder)this.customerFactory.newCustomer().title("MR").addContact(contact)).build(false);
        Assert.assertEquals((Object)"Bar <foo@bar.com>", (Object)this.formatter.getNameAddress(contact, false));
    }

    protected abstract AddressFormatter createAddressFormatter();
}

