/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.report;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.doc.TestDocumentBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.report.ReportFactory;
import org.openvpms.report.StaticContentIMReport;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.report.DocumentActReporter;
import org.springframework.beans.factory.annotation.Autowired;

public class DocumentActReporterTestCase
extends ArchetypeServiceTest {
    @Autowired
    private DocumentHandlers handlers;
    @Autowired
    private PatientRules patientRules;
    @Autowired
    private ReportFactory reportFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestPatientFactory patientFactory;

    @Test
    public void testStaticContent() throws Exception {
        byte[] content = RandomUtils.nextBytes((int)100);
        Document pdf = (Document)((TestDocumentBuilder)this.documentFactory.newDocument().name("test.pdf")).mimeType("application/pdf").content(content).build();
        Entity template = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.patientDocumentForm").document(pdf)).build();
        Party patient = this.patientFactory.createPatient();
        DocumentAct form = this.patientFactory.createForm(patient, template);
        IArchetypeService service = this.getArchetypeService();
        LookupService lookups = this.getLookupService();
        FileNameFormatter formatter = new FileNameFormatter((ArchetypeService)service, lookups, this.patientRules);
        DocumentActReporter reporter = new DocumentActReporter(form, formatter, (ArchetypeService)service, lookups, this.reportFactory);
        Assert.assertTrue((boolean)(reporter.getReport() instanceof StaticContentIMReport));
        Document document = reporter.getDocument();
        Assert.assertEquals((Object)(template.getName() + ".pdf"), (Object)document.getName());
        Assert.assertEquals((Object)"application/pdf", (Object)document.getMimeType());
        Assert.assertNotEquals((long)pdf.getId(), (long)document.getId());
        ByteArrayOutputStream actual = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)this.handlers.get(document).getContent(document), (OutputStream)actual);
        Assert.assertArrayEquals((byte[])content, (byte[])actual.toByteArray());
    }
}

