/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryTestHelper;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.test.AbstractAppTest;

public abstract class AbstractQueryTest<T extends IMObject>
extends AbstractAppTest {
    @Test
    public void testQueryByValue() {
        Query<T> query = this.createQuery();
        String value = this.getUniqueValue();
        this.setValue(query, value);
        ResultSet results = query.query();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)0L, (long)results.getResults());
        T object = this.createObject(value, true);
        results = query.query();
        List list = results.getPage(0).getResults();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(object, list.get(0));
        Assert.assertEquals((long)1L, (long)results.getPages());
    }

    @Test
    public void testGetResults() {
        Query<T> query = this.createQuery();
        ResultSet results = query.query();
        Assert.assertNotNull((Object)results);
        int size = results.getResults();
        this.createObject(true);
        this.createObject(true);
        results = query.query();
        Assert.assertEquals((long)(size + 2), (long)results.getResults());
        Assert.assertTrue((results.getPages() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testSelects() {
        Query<T> query = this.createQuery();
        T object = this.createObject(this.getUniqueValue(), false);
        this.checkSelects(false, query, object);
        this.save((IMObject)object);
        this.checkSelects(true, query, object);
    }

    protected void checkSelects(boolean selects, Query<T> query, T value) {
        QueryTestHelper.checkSelects(selects, query, value);
    }

    protected List<Reference> checkExists(T object, Query<T> query, boolean exists) {
        return QueryTestHelper.checkExists(object, query, exists);
    }

    protected void checkExists(T object, Query<T> query, List<Reference> matches, boolean exists) {
        QueryTestHelper.checkExists(object, query, matches, exists);
    }

    protected abstract Query<T> createQuery();

    protected void setValue(Query<T> query, String value) {
        query.setValue(value);
    }

    protected T createObject(boolean save) {
        return this.createObject(this.getUniqueValue(), save);
    }

    protected abstract T createObject(String var1, boolean var2);

    protected abstract String getUniqueValue();

    protected String getUniqueValue(String prefix) {
        return ValueStrategy.randomString((String)prefix);
    }

    protected List<Reference> getObjectRefs(Query<T> query) {
        return QueryTestHelper.getObjectRefs(query);
    }
}

