/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.finance.tax.CustomerTaxRules;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.ProductPriceTestHelper;
import org.openvpms.archetype.rules.product.ServiceRatioService;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.product.CustomerPricingContext;

public class CustomerPricingContextTestCase
extends ArchetypeServiceTest {
    @Test
    public void testPricingWithNoTaxAndShowPricesTaxExclusive() {
        this.checkPrice("10.00", "10.05", false, "0.00", "0.20", false);
        this.checkPrice("10.00", "10.062", false, "0.00", "0.20", false);
    }

    @Test
    public void testPricingWithNoTaxAndShowPricesTaxInclusive() {
        this.checkPrice("10.00", "10.05", true, "0.00", "0.20", false);
        this.checkPrice("10.00", "10.062", true, "0.00", "0.20", false);
        this.checkPrice("10.20", "10.11", true, "0.00", "0.20", false);
    }

    @Test
    public void testPricingWithTaxAndShowPricesTaxExclusive() {
        this.checkPrice("11.00", "10.05", false, "10.00", "0.20", false);
        this.checkPrice("11.00", "10.062", false, "10.00", "0.20", false);
    }

    @Test
    public void testPricingWithTaxAndShowPricesTaxInclusive() {
        this.checkPrice("11.00", "10.05", true, "10.00", "0.20", false);
        this.checkPrice("11.00", "10.062", true, "10.00", "0.20", false);
        this.checkPrice("11.20", "10.11", true, "10.00", "0.20", false);
    }

    private void checkPrice(String expected, String taxExPrice, boolean showPricesTaxInclusive, String taxRate, String minPrice, boolean customerHasTaxExclusion) {
        Party customer = TestHelper.createCustomer((boolean)false);
        Party practice = (Party)TestHelper.create((String)"party.organisationPractice");
        IMObjectBean bean = this.getBean((IMObject)practice);
        bean.setValue("showPricesTaxInclusive", (Object)showPricesTaxInclusive);
        Party location = (Party)TestHelper.create((String)"party.organisationLocation");
        LocationRules locationRules = new LocationRules(this.getArchetypeService());
        ProductPriceRules productPriceRules = new ProductPriceRules((ArchetypeService)this.getArchetypeService());
        Currency currency = this.getCurrency(new BigDecimal(minPrice));
        CustomerTaxRules taxRules = new CustomerTaxRules(practice, this.getArchetypeService());
        ServiceRatioService serviceRatios = (ServiceRatioService)Mockito.mock(ServiceRatioService.class);
        CustomerPricingContext context = new CustomerPricingContext(customer, location, currency, productPriceRules, locationRules, taxRules, serviceRatios);
        Product product = (Product)TestHelper.create((String)"product.medication");
        BigDecimal rate = new BigDecimal(taxRate);
        if (!MathRules.isZero((BigDecimal)rate)) {
            Lookup taxType = TestHelper.createTaxType((BigDecimal)rate);
            product.addClassification(taxType);
            if (customerHasTaxExclusion) {
                customer.addClassification(taxType);
            }
        }
        BigDecimal price = context.getPrice(product, this.getPrice(taxExPrice), BigDecimal.ONE);
        this.checkEquals(new BigDecimal(expected), price);
    }

    private ProductPrice getPrice(String price) {
        return ProductPriceTestHelper.createUnitPrice((String)price, (String)"0", (String)"0", (String)"100", (Date)null, null);
    }

    private Currency getCurrency(BigDecimal minPrice) {
        return new Currency(java.util.Currency.getInstance("AUD"), RoundingMode.HALF_UP, new BigDecimal("0.05"), minPrice);
    }
}

