/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.act;

import java.math.BigDecimal;
import java.util.List;
import nextapp.echo2.app.button.AbstractButton;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.DefaultIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActEditDialog;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class ActEditDialogTestCase
extends AbstractAppTest {
    private LayoutContext context;
    private FinancialAct charge;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Party customer = TestHelper.createCustomer();
        Product product = TestHelper.createProduct();
        List acts = FinancialTestHelper.createChargesCounter((BigDecimal)BigDecimal.TEN, (Party)customer, (Product)product, (String)"IN_PROGRESS");
        this.save(acts);
        this.charge = (FinancialAct)acts.get(0);
        this.context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
    }

    @Test
    public void testChangeStatus() {
        DefaultIMObjectEditor editor = new DefaultIMObjectEditor((IMObject)this.charge, this.context);
        ActEditDialog dialog = new ActEditDialog((IMObjectEditor)editor, this.context.getContext());
        dialog.show();
        this.checkEnabled(dialog, "apply", true);
        this.checkEnabled(dialog, "ok", true);
        this.checkEnabled(dialog, "cancel", true);
        this.setStatus(dialog, "POSTED");
        this.checkEnabled(dialog, "apply", false);
        this.checkEnabled(dialog, "ok", true);
        this.checkEnabled(dialog, "cancel", true);
        this.setStatus(dialog, "IN_PROGRESS");
        this.checkEnabled(dialog, "apply", true);
        this.checkEnabled(dialog, "ok", true);
        this.checkEnabled(dialog, "cancel", true);
    }

    @Test
    public void testReload() {
        DefaultIMObjectEditor editor = new DefaultIMObjectEditor((IMObject)this.charge, this.context);
        ActEditDialog dialog = new ActEditDialog((IMObjectEditor)editor, this.context.getContext());
        dialog.show();
        this.setStatus(dialog, "POSTED");
        this.checkEnabled(dialog, "apply", false);
        this.checkEnabled(dialog, "ok", true);
        this.checkEnabled(dialog, "cancel", true);
        Act copy = (Act)this.get((IMObject)this.charge);
        copy.setStatus("COMPLETED");
        this.save((IMObject)copy);
        dialog.save(true);
        Assert.assertNotNull((Object)dialog.getEditor());
        Assert.assertNotEquals((Object)editor, (Object)dialog.getEditor());
        this.checkStatus(dialog, "COMPLETED");
        this.checkEnabled(dialog, "apply", true);
        this.checkEnabled(dialog, "ok", true);
        this.checkEnabled(dialog, "cancel", true);
        this.setStatus(dialog, "POSTED");
        this.checkEnabled(dialog, "apply", false);
        this.checkEnabled(dialog, "ok", true);
        this.checkEnabled(dialog, "cancel", true);
        copy.setStatus("POSTED");
        this.save((IMObject)copy);
        editor = dialog.getEditor();
        dialog.save(true);
        Assert.assertNotNull((Object)dialog.getEditor());
        Assert.assertNotEquals((Object)editor, (Object)dialog.getEditor());
        this.checkStatus(dialog, "POSTED");
        this.checkEnabled(dialog, "apply", false);
        this.checkEnabled(dialog, "ok", false);
        this.checkEnabled(dialog, "cancel", true);
    }

    @Test
    public void testDelete() {
        DefaultIMObjectEditor editor = new DefaultIMObjectEditor((IMObject)this.charge, this.context);
        ActEditDialog dialog = new ActEditDialog((IMObjectEditor)editor, this.context.getContext());
        dialog.show();
        TransactionTemplate template = new TransactionTemplate(ServiceHelper.getTransactionManager());
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                ServiceHelper.getArchetypeService().remove((IMObject)ActEditDialogTestCase.this.charge);
            }
        });
        this.setStatus(dialog, "COMPLETED");
        dialog.save(true);
        Assert.assertNotNull((Object)dialog.getEditor());
        Assert.assertEquals((Object)editor, (Object)dialog.getEditor());
        this.checkEnabled(dialog, "apply", false);
        this.checkEnabled(dialog, "ok", false);
        this.checkEnabled(dialog, "cancel", true);
    }

    private void setStatus(ActEditDialog dialog, String status) {
        IMObjectEditor editor = dialog.getEditor();
        Assert.assertNotNull((Object)editor);
        editor.getProperty("status").setValue((Object)status);
    }

    private void checkStatus(ActEditDialog dialog, String status) {
        IMObjectEditor editor = dialog.getEditor();
        Assert.assertNotNull((Object)editor);
        Assert.assertEquals((Object)status, (Object)editor.getProperty("status").getString());
    }

    private void checkEnabled(ActEditDialog dialog, String id, boolean expected) {
        AbstractButton button = dialog.getButtons().getButton(id);
        Assert.assertNotNull((Object)button);
        Assert.assertEquals((Object)expected, (Object)button.isEnabled());
    }
}

