/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.SelectorIMObjectCollectionEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetBuilder;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;

public class SelectorIMObjectCollectionEditorTestCase
extends AbstractAppTest {
    @Test
    public void testAddRemove() {
        Party customer = TestHelper.createCustomer((boolean)false);
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        PropertySet set = new PropertySetBuilder((IMObject)customer, (LayoutContext)layoutContext).build();
        CollectionProperty property = (CollectionProperty)set.get("type");
        SelectorIMObjectCollectionEditor editor = new SelectorIMObjectCollectionEditor(property, (IMObject)customer, (LayoutContext)layoutContext);
        MutableInt modCount = new MutableInt(0);
        editor.addModifiableListener(modifiable -> modCount.setValue(modCount.intValue() + 1));
        Assert.assertFalse((boolean)editor.isModified());
        Lookup accountType = TestHelper.getLookup((String)"lookup.customerAccountType", (String)"BAD_DEBT");
        editor.add((IMObject)accountType);
        Assert.assertEquals((long)1L, (long)modCount.intValue());
        Assert.assertEquals((long)1L, (long)property.getValues().size());
        Assert.assertTrue((boolean)property.getValues().contains(accountType));
        Assert.assertTrue((boolean)editor.isModified());
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertFalse((boolean)editor.isSaved());
        editor.save();
        Assert.assertTrue((boolean)editor.isSaved());
        Assert.assertFalse((boolean)editor.isModified());
        editor.remove((IMObject)accountType);
        Assert.assertTrue((boolean)property.getValues().isEmpty());
        Assert.assertEquals((long)2L, (long)modCount.intValue());
        Assert.assertTrue((boolean)editor.isModified());
        Assert.assertTrue((boolean)editor.isValid());
    }
}

