/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.IMObjects;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.MapIMObjectCache;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.IMObjectProperty;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractCollectionPropertyEditorTest
extends AbstractAppTest {
    private IMObjects objects;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.objects = new MapIMObjectCache((ArchetypeService)this.getArchetypeService());
    }

    @Test
    public void testEmpty() {
        IMObject parent = this.createParent();
        CollectionProperty property = this.getCollectionProperty(parent);
        CollectionPropertyEditor editor = this.createEditor(property, parent, this.objects);
        Assert.assertTrue((String)"Collection should be empty", (boolean)editor.getObjects().isEmpty());
        Assert.assertFalse((String)"Collection shouldn't be modified", (boolean)editor.isModified());
        Assert.assertSame((Object)property, (Object)editor.getProperty());
        Assert.assertFalse((String)"Collection not saved", (boolean)editor.isSaved());
        if (property.getMinCardinality() > 0) {
            Assert.assertFalse((String)"Collection should be invalid", (boolean)editor.isValid());
        } else {
            Assert.assertTrue((String)"Collection should be valid", (boolean)editor.isValid());
        }
    }

    @Test
    public void testSave() {
        IMObject parent = this.createParent();
        CollectionProperty property = this.getCollectionProperty(parent);
        Assert.assertTrue((String)"Require collection with min cardinality >= 0", (property.getMinCardinality() >= 0 ? 1 : 0) != 0);
        CollectionPropertyEditor editor = this.createEditor(property, parent, this.objects);
        Assert.assertFalse((boolean)editor.isModified());
        IMObject element = this.createObject(parent);
        editor.add(element);
        Assert.assertEquals((long)1L, (long)editor.getObjects().size());
        Assert.assertSame((Object)element, editor.getObjects().get(0));
        Assert.assertTrue((String)"Collection should be valid", (boolean)editor.isValid());
        Assert.assertTrue((String)"Collection should be modified", (boolean)editor.isModified());
        this.save(editor, parent);
        Assert.assertTrue((boolean)editor.isSaved());
        Assert.assertFalse((boolean)editor.isModified());
        Assert.assertEquals((String)"Retrieved element doesnt match that saved", (Object)element, (Object)this.get(element));
        IMObject savedParent = this.get(parent);
        Assert.assertNotNull((Object)savedParent);
        CollectionPropertyEditor saved = this.createEditor(this.getCollectionProperty(savedParent), savedParent, this.objects);
        Assert.assertEquals((long)1L, (long)saved.getObjects().size());
        Assert.assertTrue((boolean)saved.getObjects().contains(element));
        Assert.assertFalse((String)"Collection shouldn't be modified", (boolean)saved.isModified());
        Assert.assertFalse((String)"Collection not saved", (boolean)saved.isSaved());
        Assert.assertTrue((String)"Collection should be valid", (boolean)saved.isValid());
        this.save(editor, parent);
    }

    @Test
    public void testRemove() {
        IMObject parent = this.createParent();
        CollectionProperty property = this.getCollectionProperty(parent);
        Assert.assertTrue((String)"Require collection with min cardinality >= 0", (property.getMinCardinality() >= 0 ? 1 : 0) != 0);
        CollectionPropertyEditor editor = this.createEditor(property, parent, this.objects);
        IMObject elt1 = this.createObject(parent);
        IMObject elt2 = this.createObject(parent);
        IMObject elt3 = this.createObject(parent);
        editor.add(elt1);
        editor.add(elt2);
        editor.add(elt3);
        Assert.assertEquals((long)3L, (long)editor.getObjects().size());
        Assert.assertTrue((boolean)editor.getObjects().contains(elt1));
        Assert.assertTrue((boolean)editor.getObjects().contains(elt2));
        Assert.assertTrue((boolean)editor.getObjects().contains(elt3));
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertTrue((boolean)editor.isModified());
        this.save(editor, parent);
        Assert.assertFalse((boolean)editor.isModified());
        Assert.assertEquals((String)"Retrieved element1 doesnt match that saved", (Object)elt1, (Object)this.get(elt1));
        Assert.assertEquals((String)"Retrieved element2 doesnt match that saved", (Object)elt2, (Object)this.get(elt2));
        Assert.assertEquals((String)"Retrieved element3 doesnt match that saved", (Object)elt3, (Object)this.get(elt3));
        editor.remove(elt1);
        Assert.assertTrue((boolean)editor.isModified());
        editor.remove(elt2);
        Assert.assertTrue((boolean)editor.isModified());
        Assert.assertEquals((long)1L, (long)editor.getObjects().size());
        Assert.assertFalse((boolean)editor.getObjects().contains(elt1));
        Assert.assertFalse((boolean)editor.getObjects().contains(elt2));
        Assert.assertTrue((boolean)editor.getObjects().contains(elt3));
        this.save(editor, parent);
        Assert.assertNull((String)"element1 wasnt deleted", (Object)this.get(elt1));
        Assert.assertNull((String)"element2 wasnt deleted", (Object)this.get(elt2));
        Assert.assertFalse((boolean)editor.isModified());
        IMObject savedParent = this.get(parent);
        Assert.assertNotNull((Object)savedParent);
        CollectionPropertyEditor saved = this.createEditor(this.getCollectionProperty(savedParent), savedParent, this.objects);
        Assert.assertEquals((long)1L, (long)saved.getObjects().size());
        Assert.assertTrue((boolean)saved.getObjects().contains(elt3));
        Assert.assertFalse((String)"Collection shouldn't be modified", (boolean)saved.isModified());
        Assert.assertFalse((String)"Collection not saved", (boolean)saved.isSaved());
        Assert.assertTrue((String)"Collection should be valid", (boolean)saved.isValid());
        this.save(editor, parent);
    }

    @Test
    public void testRemoveAndAdd() {
        IMObject parent = this.createParent();
        CollectionProperty property = this.getCollectionProperty(parent);
        Assert.assertTrue((String)"Require collection with min cardinality >= 0", (property.getMinCardinality() >= 0 ? 1 : 0) != 0);
        CollectionPropertyEditor editor = this.createEditor(property, parent, this.objects);
        IMObject elt1 = this.createObject(parent);
        IMObject elt2 = this.createObject(parent);
        IMObject elt3 = this.createObject(parent);
        editor.add(elt1);
        Assert.assertEquals((long)1L, (long)editor.getObjects().size());
        Assert.assertTrue((boolean)editor.getObjects().contains(elt1));
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertTrue((boolean)editor.isModified());
        this.save(editor, parent);
        Assert.assertEquals((String)"Retrieved element1 doesnt match that saved", (Object)elt1, (Object)this.get(elt1));
        editor.remove(elt1);
        editor.add(elt2);
        Assert.assertEquals((long)1L, (long)editor.getObjects().size());
        Assert.assertFalse((boolean)editor.getObjects().contains(elt1));
        Assert.assertTrue((boolean)editor.getObjects().contains(elt2));
        this.save(editor, parent);
        Assert.assertNull((String)"element1 wasnt deleted", (Object)this.get(elt1));
        IMObject savedParent = this.get(parent);
        Assert.assertNotNull((Object)savedParent);
        CollectionPropertyEditor saved = this.createEditor(this.getCollectionProperty(savedParent), savedParent, this.objects);
        Assert.assertEquals((long)1L, (long)saved.getObjects().size());
        Assert.assertTrue((boolean)saved.getObjects().contains(elt2));
        Assert.assertFalse((String)"Collection shouldn't be modified", (boolean)saved.isModified());
        Assert.assertFalse((String)"Collection not saved", (boolean)saved.isSaved());
        Assert.assertTrue((String)"Collection should be valid", (boolean)saved.isValid());
        this.save(editor, parent);
        editor.add(elt3);
        editor.getEditor(elt3);
        editor.remove(elt3);
        this.save(editor, parent);
    }

    @Test
    public void testRemoveAfterReload() {
        IMObject parent = this.createParent();
        CollectionProperty property = this.getCollectionProperty(parent);
        Assert.assertTrue((String)"Require collection with min cardinality >= 0", (property.getMinCardinality() >= 0 ? 1 : 0) != 0);
        CollectionPropertyEditor editor = this.createEditor(property, parent, this.objects);
        IMObject elt1 = this.createObject(parent);
        IMObject elt2 = this.createObject(parent);
        editor.add(elt1);
        editor.add(elt2);
        Assert.assertEquals((long)2L, (long)editor.getObjects().size());
        Assert.assertTrue((boolean)editor.getObjects().contains(elt1));
        Assert.assertTrue((boolean)editor.getObjects().contains(elt2));
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertTrue((boolean)editor.isModified());
        this.save(editor, parent);
        Assert.assertEquals((String)"Retrieved element1 doesnt match that saved", (Object)elt1, (Object)this.get(elt1));
        Assert.assertEquals((String)"Retrieved element2 doesnt match that saved", (Object)elt2, (Object)this.get(elt2));
        IMObject parent2 = this.get(parent);
        CollectionPropertyEditor editor2 = this.createEditor(this.getCollectionProperty(parent2), parent2, this.objects);
        Assert.assertEquals((long)2L, (long)editor2.getObjects().size());
        elt1 = this.get(elt1);
        elt2 = this.get(elt2);
        editor2.remove(elt1);
        Assert.assertEquals((long)1L, (long)editor2.getObjects().size());
        Assert.assertFalse((boolean)editor2.getObjects().contains(elt1));
        Assert.assertTrue((boolean)editor2.getObjects().contains(elt2));
        this.save(editor2, parent2);
        Assert.assertNull((String)"element1 wasnt deleted", (Object)this.get(elt1));
        IMObject savedParent = this.get(parent2);
        Assert.assertNotNull((Object)savedParent);
        CollectionPropertyEditor saved = this.createEditor(this.getCollectionProperty(savedParent), savedParent, this.objects);
        Assert.assertEquals((long)1L, (long)saved.getObjects().size());
        Assert.assertTrue((boolean)saved.getObjects().contains(elt2));
        Assert.assertFalse((String)"Collection shouldn't be modified", (boolean)saved.isModified());
        Assert.assertFalse((String)"Collection not saved", (boolean)saved.isSaved());
        Assert.assertTrue((String)"Collection should be valid", (boolean)saved.isValid());
        this.save(editor2, parent2);
    }

    @Test
    public void testClearModified() {
        IMObject parent = this.createParent();
        CollectionProperty property = this.getCollectionProperty(parent);
        CollectionPropertyEditor editor = this.createEditor(property, parent, this.objects);
        Assert.assertFalse((boolean)editor.isModified());
        IMObject element = this.createObject(parent);
        editor.add(element);
        Assert.assertEquals((long)1L, (long)editor.getObjects().size());
        Assert.assertTrue((boolean)editor.isModified());
        editor.clearModified();
        Assert.assertFalse((boolean)editor.isModified());
    }

    @Test
    public void testValidation() {
        IMObject parent = this.createParent();
        CollectionProperty property = this.getCollectionProperty(parent);
        CollectionPropertyEditor editor = this.createEditor(property, parent, this.objects);
        IMObject element1 = this.createObject(parent);
        IMObject element2 = this.createObject(parent);
        IMObject element3 = this.createObject(parent);
        editor.add(element1);
        editor.add(element2);
        editor.add(element3);
        Assert.assertTrue((boolean)editor.isValid());
        this.makeValid(element1, false);
        editor.resetValid();
        Assert.assertFalse((boolean)editor.isValid());
        this.makeValid(element1, true);
        editor.resetValid();
        Assert.assertTrue((boolean)editor.isValid());
        this.makeValid(element2, false);
        editor.resetValid();
        Assert.assertFalse((boolean)editor.isValid());
        this.makeValid(element2, true);
        editor.resetValid();
        Assert.assertTrue((boolean)editor.isValid());
        this.makeValid(element3, false);
        editor.resetValid();
        Assert.assertFalse((boolean)editor.isValid());
        this.makeValid(element3, true);
        editor.resetValid();
        Assert.assertTrue((boolean)editor.isValid());
    }

    protected abstract IMObject createParent();

    protected abstract String getCollectionNode();

    protected CollectionProperty getCollectionProperty(IMObject parent) {
        ArchetypeDescriptor archetype = DescriptorHelper.getArchetypeDescriptor((IMObject)parent, (ArchetypeService)this.getArchetypeService());
        Assert.assertNotNull((Object)archetype);
        NodeDescriptor node = archetype.getNodeDescriptor(this.getCollectionNode());
        Assert.assertNotNull((Object)node);
        return new IMObjectProperty(parent, (org.openvpms.component.model.archetype.NodeDescriptor)node);
    }

    protected abstract CollectionPropertyEditor createEditor(CollectionProperty var1, IMObject var2, IMObjects var3);

    protected abstract IMObject createObject(IMObject var1);

    protected abstract void makeValid(IMObject var1, boolean var2);

    protected abstract void modify(IMObject var1);

    protected void execute(TransactionCallback<Object> callback) {
        TransactionTemplate template = new TransactionTemplate(ServiceHelper.getTransactionManager());
        template.execute(callback);
    }

    protected void save(final CollectionPropertyEditor editor, final IMObject parent) {
        this.execute((TransactionCallback<Object>)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                editor.save();
                Assert.assertTrue((String)"Failed to save parent", (boolean)SaveHelper.save((IMObject)parent));
            }
        });
    }

    protected IMObjects getObjects() {
        return this.objects;
    }
}

