/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.act.ActHelper;
import org.openvpms.web.component.im.delete.ActDeletionHandler;
import org.openvpms.web.component.im.doc.AbstractDocumentActEditorTest;
import org.openvpms.web.component.im.doc.DocumentActEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class VersionedDocumentActEditorTest<T extends DocumentActEditor>
extends AbstractDocumentActEditorTest<T> {
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private IArchetypeRuleService ruleService;

    public VersionedDocumentActEditorTest(Class<T> type, String archetype) {
        super(type, archetype);
    }

    @Test
    public void testVersioning() {
        this.checkVersioning(false);
        this.checkVersioning(true);
    }

    protected abstract Document createDocument();

    protected List<DocumentAct> sort(List<DocumentAct> versions) {
        return ActHelper.sort(versions);
    }

    private void checkVersioning(boolean useDeletionHandler) {
        DocumentAct act = this.createAct();
        DocumentActEditor editor = this.createEditor(act);
        Document doc1 = this.createDocument();
        Document doc2 = this.createDocument();
        Document doc3 = this.createDocument();
        editor.setDocument((org.openvpms.component.model.document.Document)doc1);
        Assert.assertEquals((Object)doc1.getObjectReference(), (Object)act.getDocument());
        this.save(editor);
        editor.setDocument((org.openvpms.component.model.document.Document)doc2);
        Assert.assertEquals((Object)doc2.getObjectReference(), (Object)act.getDocument());
        this.save(editor);
        editor.setDocument((org.openvpms.component.model.document.Document)doc3);
        Assert.assertEquals((Object)doc3.getObjectReference(), (Object)act.getDocument());
        this.save(editor);
        IMObjectBean bean = this.getBean((IMObject)act);
        List<DocumentAct> versions = this.sort(bean.getTargets("versions", DocumentAct.class));
        Assert.assertEquals((long)2L, (long)versions.size());
        DocumentAct version1 = versions.get(0);
        Assert.assertEquals((Object)doc1.getObjectReference(), (Object)version1.getDocument());
        DocumentAct version2 = versions.get(1);
        Assert.assertEquals((Object)doc2.getObjectReference(), (Object)version2.getDocument());
        Assert.assertNotNull((Object)this.get((IMObject)doc1));
        Assert.assertNotNull((Object)this.get((IMObject)doc2));
        Assert.assertNotNull((Object)this.get((IMObject)doc3));
        if (useDeletionHandler) {
            IMObjectEditorFactory factory = new IMObjectEditorFactory(this.getArchetypeService());
            ActDeletionHandler handler = new ActDeletionHandler((Act)act, factory, this.transactionManager, this.ruleService);
            handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        } else {
            this.delete(editor);
        }
        Assert.assertNull((Object)this.get((IMObject)act));
        Assert.assertNull((Object)this.get((IMObject)version1));
        Assert.assertNull((Object)this.get((IMObject)version2));
        Assert.assertNull((Object)this.get((IMObject)doc1));
        Assert.assertNull((Object)this.get((IMObject)doc2));
        Assert.assertNull((Object)this.get((IMObject)doc3));
    }
}

