/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.delete;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.delete.Deletable;
import org.openvpms.web.component.im.delete.EntityDeletionHandler;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;

public class EntityDeletionHandlerTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;

    @Test
    public void testDeleteWithRelationships() {
        Party customer = TestHelper.createCustomer();
        EntityDeletionHandler<Party> customerHandler = this.createDeletionHandler(customer);
        Assert.assertTrue((boolean)customerHandler.getDeletable().canDelete());
        Party patient = TestHelper.createPatient((Party)customer);
        Deletable deletable = customerHandler.getDeletable();
        Assert.assertFalse((boolean)deletable.canDelete());
        Assert.assertEquals((Object)"Customer has relationships and cannot be deleted.", (Object)deletable.getReason());
        EntityDeletionHandler<Party> patientHandler = this.createDeletionHandler(patient);
        Assert.assertTrue((boolean)patientHandler.getDeletable().canDelete());
        patientHandler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)patient));
        customer = (Party)this.get((IMObject)customer);
        Assert.assertNotNull((Object)customer);
        customerHandler = this.createDeletionHandler(customer);
        Assert.assertTrue((boolean)customerHandler.getDeletable().canDelete());
        customerHandler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)customer));
    }

    @Test
    public void testDeleteWithLinks() {
        Entity type = ProductTestHelper.createProductType();
        Product product = ProductTestHelper.createMedication((Entity)type);
        EntityDeletionHandler<Product> productHandler = this.createDeletionHandler(product);
        Assert.assertTrue((boolean)productHandler.getDeletable().canDelete());
        EntityDeletionHandler<Entity> typeHandler = this.createDeletionHandler(type);
        Assert.assertFalse((boolean)typeHandler.getDeletable().canDelete());
        productHandler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)product));
        Assert.assertNotNull((Object)this.get((IMObject)type));
        Assert.assertTrue((boolean)typeHandler.getDeletable().canDelete());
        typeHandler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)type));
    }

    @Test
    public void testDeletionWithParticipations() {
        Party customer = TestHelper.createCustomer();
        List invoice = FinancialTestHelper.createChargesCounter((BigDecimal)new BigDecimal("100"), (Party)customer, (Product)TestHelper.createProduct(), (String)"POSTED");
        this.save(invoice);
        EntityDeletionHandler<Party> customerHandler = this.createDeletionHandler(customer);
        Deletable deletable = customerHandler.getDeletable();
        Assert.assertFalse((boolean)deletable.canDelete());
        Assert.assertEquals((Object)"Customer has relationships and cannot be deleted.", (Object)deletable.getReason());
    }

    @Test
    public void testFactory() {
        IMObjectDeletionHandlerFactory factory = new IMObjectDeletionHandlerFactory(this.getArchetypeService());
        Assert.assertNotNull((Object)this.applicationContext);
        factory.setApplicationContext(this.applicationContext);
        Entity entity = ProductTestHelper.createProductType();
        Party party = TestHelper.createCustomer((boolean)false);
        Product product = TestHelper.createProduct();
        Assert.assertTrue((boolean)(factory.create((IMObject)entity) instanceof EntityDeletionHandler));
        Assert.assertTrue((boolean)(factory.create((IMObject)party) instanceof EntityDeletionHandler));
        Assert.assertTrue((boolean)(factory.create((IMObject)product) instanceof EntityDeletionHandler));
    }

    protected <T extends Entity> EntityDeletionHandler<T> createDeletionHandler(T entity) {
        return new EntityDeletionHandler(entity, this.factory, ServiceHelper.getTransactionManager(), ServiceHelper.getArchetypeService());
    }
}

