/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.act;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestEstimateBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.archetype.test.builder.supplier.delivery.TestDeliveryBuilder;
import org.openvpms.archetype.test.builder.supplier.delivery.TestDeliveryItemBuilder;
import org.openvpms.archetype.test.builder.supplier.order.TestOrderBuilder;
import org.openvpms.archetype.test.builder.supplier.order.TestOrderItemBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.act.PrintedFlagUpdater;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;

public class PrintedFlagUpdaterTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;

    @Test
    public void testSetPrinted() {
        DocumentAct act = this.patientFactory.createForm(this.patientFactory.createPatient());
        this.checkPrinted((Act)act, false);
        PrintedFlagUpdater updater = new PrintedFlagUpdater();
        Act updated = updater.setPrinted((Act)act);
        Assert.assertNotNull((Object)updated);
        Assert.assertSame((Object)act, (Object)updated);
        this.checkPrinted((Act)act, true);
        Assert.assertNull((Object)updater.setPrinted((Act)act));
        this.checkPrinted((Act)act, true);
    }

    @Test
    public void testSetPrintedForModifiedObject() {
        DocumentAct original = this.patientFactory.createForm(this.patientFactory.createPatient());
        DocumentAct updated = (DocumentAct)this.get((IMObject)original);
        updated.setDescription("A description to force a version change");
        this.save((IMObject)updated);
        Assert.assertNotEquals((long)original.getVersion(), (long)updated.getVersion());
        this.checkPrinted((Act)updated, false);
        PrintedFlagUpdater updater = new PrintedFlagUpdater();
        updater.setPrinted((Act)original);
        Act reloaded = (Act)this.get((IMObject)original);
        this.checkPrinted(reloaded, true);
        Assert.assertEquals((Object)"A description to force a version change", (Object)reloaded.getDescription());
    }

    @Test
    public void testSetPrintedOnDeletedObject() {
        DocumentAct act = this.patientFactory.createForm(this.patientFactory.createPatient());
        this.remove((IMObject)act);
        PrintedFlagUpdater updater = new PrintedFlagUpdater();
        Assert.assertNull((Object)updater.setPrinted((Act)act));
    }

    @Test
    public void testSetPrintedOnAccountAct() {
        Party customer = this.customerFactory.createCustomer();
        FinancialAct invoice = (FinancialAct)((TestInvoiceBuilder)((TestInvoiceBuilder)this.accountFactory.newInvoice().customer(customer)).status("IN_PROGRESS")).build();
        FinancialAct payment = (FinancialAct)((TestPaymentBuilder)((TestPaymentBuilder)((TestPaymentBuilder)this.accountFactory.newPayment().customer(customer)).till(this.practiceFactory.createTill())).status("IN_PROGRESS")).cash(100).build();
        this.checkPrintFinancialAct((Act)invoice);
        this.checkPrintFinancialAct((Act)payment);
    }

    @Test
    public void testSetPrintOnEstimate() {
        Party customer = this.customerFactory.createCustomer();
        Act estimate = (Act)((TestEstimateBuilder)this.accountFactory.newEstimate().customer(customer).status("IN_PROGRESS")).item().patient(this.patientFactory.createPatient()).product(this.productFactory.createMedication()).add().build();
        this.checkPrintFinancialAct(estimate);
    }

    @Test
    public void testSetPrintOnSupplierActs() {
        Party supplier = this.supplierFactory.createSupplier();
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        FinancialAct order = (FinancialAct)((TestOrderBuilder)((TestOrderItemBuilder)((TestOrderBuilder)((TestOrderBuilder)((TestOrderBuilder)this.supplierFactory.newOrder().supplier(supplier)).stockLocation(stockLocation)).status("IN_PROGRESS")).item().product(this.productFactory.createMerchandise())).add()).build();
        FinancialAct delivery = (FinancialAct)((TestDeliveryBuilder)((TestDeliveryItemBuilder)((TestDeliveryBuilder)((TestDeliveryBuilder)((TestDeliveryBuilder)this.supplierFactory.newDelivery().supplier(supplier)).stockLocation(stockLocation)).status("IN_PROGRESS")).item().product(this.productFactory.createMerchandise())).add()).build();
        this.checkPrintSupplierAct((Act)order);
        this.checkPrintSupplierAct((Act)delivery);
    }

    @Test
    public void testFinalStatuses() {
        String[] finalStatuses = new String[]{"POSTED", "CANCELLED", "REJECTED", "ACCEPTED"};
        PrintedFlagUpdater updater = new PrintedFlagUpdater(finalStatuses);
        FinancialAct act = (FinancialAct)((TestOrderBuilder)((TestOrderItemBuilder)((TestOrderBuilder)((TestOrderBuilder)((TestOrderBuilder)this.supplierFactory.newOrder().supplier(this.supplierFactory.createSupplier())).stockLocation(this.practiceFactory.createStockLocation(new Party[0]))).status("IN_PROGRESS")).item().product(this.productFactory.createMerchandise())).add()).build();
        Assert.assertNull((Object)updater.setPrinted((Act)act));
        this.checkPrinted((Act)this.get((IMObject)act), false);
        this.setStatus((Act)act, "COMPLETED");
        Assert.assertNull((Object)updater.setPrinted((Act)act));
        this.checkPrinted((Act)this.get((IMObject)act), false);
        for (String status : finalStatuses) {
            this.setStatus((Act)act, status);
            Assert.assertNotNull((Object)updater.setPrinted((Act)act));
            this.checkPrinted((Act)this.get((IMObject)act), true);
        }
    }

    private void checkPrintFinancialAct(Act act) {
        PrintedFlagUpdater updater = new PrintedFlagUpdater();
        Assert.assertNull((Object)updater.setPrinted(act));
        this.checkPrinted((Act)this.get((IMObject)act), false);
        act.setStatus("POSTED");
        this.save((IMObject)act);
        Assert.assertNotNull((Object)updater.setPrinted(act));
        this.checkPrinted((Act)this.get((IMObject)act), true);
    }

    private void checkPrintSupplierAct(Act act) {
        PrintedFlagUpdater updater = new PrintedFlagUpdater();
        Assert.assertNull((Object)updater.setPrinted(act));
        this.checkPrinted((Act)this.get((IMObject)act), false);
        act.setStatus("POSTED");
        this.save((IMObject)act);
        Assert.assertNotNull((Object)updater.setPrinted(act));
        this.checkPrinted((Act)this.get((IMObject)act), true);
        this.setStatus(act, "CANCELLED");
        Assert.assertNotNull((Object)updater.setPrinted(act));
        this.checkPrinted((Act)this.get((IMObject)act), true);
    }

    private void setStatus(Act act, String status) {
        IMObjectBean bean = this.getBean((IMObject)act);
        bean.setValue("printed", (Object)false);
        act.setStatus(status);
        bean.save();
    }

    private void checkPrinted(Act act, boolean expected) {
        IMObjectBean bean = this.getBean((IMObject)act);
        Assert.assertEquals((Object)expected, (Object)bean.getBoolean("printed"));
    }
}

