/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.edit;

import nextapp.echo2.app.Component;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.web.component.edit.AbstractPropertyEditor;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.Editors;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.ModifiableListeners;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetImpl;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.focus.FocusGroup;

public class EditorsTestCase {
    @Test
    public void testModified() {
        SimpleProperty property1 = new SimpleProperty("p1", String.class);
        SimpleProperty property2 = new SimpleProperty("p2", String.class);
        PropertySetImpl set = new PropertySetImpl(new Property[]{property1, property2});
        ModifiableListeners listeners = new ModifiableListeners();
        Editors editors = new Editors((PropertySet)set, listeners);
        Assert.assertFalse((boolean)editors.isModified());
        property1.setValue((Object)"foo");
        Assert.assertTrue((boolean)editors.isModified());
        Assert.assertTrue((boolean)property1.isModified());
        Assert.assertFalse((boolean)property2.isModified());
        editors.clearModified();
        Assert.assertFalse((boolean)editors.isModified());
        Assert.assertFalse((boolean)property1.isModified());
        Assert.assertFalse((boolean)property2.isModified());
    }

    @Test
    public void testPropertyListeners() {
        SimpleProperty property = new SimpleProperty("property", String.class);
        PropertySetImpl set = new PropertySetImpl(new Property[]{property});
        ModifiableListeners listeners = new ModifiableListeners();
        Editors editors = new Editors((PropertySet)set, listeners);
        CountingListener editorsListener = new CountingListener();
        editors.addModifiableListener((ModifiableListener)editorsListener);
        property.setValue((Object)"foo");
        Assert.assertEquals((long)1L, (long)editorsListener.getCount());
        SimplePropertyEditor editor = new SimplePropertyEditor(property);
        editors.add((Editor)editor);
        property.setValue((Object)"bar");
        Assert.assertEquals((long)2L, (long)editorsListener.getCount());
        editors.remove((Editor)editor);
        property.setValue((Object)"foo");
        Assert.assertEquals((long)3L, (long)editorsListener.getCount());
    }

    @Test
    public void testEditorChangeDurationValidation() {
        SimpleProperty property1 = new SimpleProperty("p1", String.class);
        SimpleProperty property2 = new SimpleProperty("p2", String.class);
        PropertySetImpl set = new PropertySetImpl(new Property[]{property1, property2});
        ModifiableListeners listeners = new ModifiableListeners();
        final MutableInt flag = new MutableInt(0);
        final Editors editors = new Editors((PropertySet)set, listeners);
        final SimplePropertyEditor propertyEditor2 = new SimplePropertyEditor(property2);
        SimplePropertyEditor propertyEditor1 = new SimplePropertyEditor(property1){

            public boolean validate(Validator validator) {
                if (flag.intValue() == 0) {
                    editors.add((Editor)propertyEditor2);
                } else if (flag.intValue() == 1) {
                    editors.remove((Editor)propertyEditor2);
                }
                flag.setValue(flag.intValue() + 1);
                return super.validate(validator);
            }
        };
        editors.add((Editor)propertyEditor1);
        Assert.assertFalse((boolean)editors.isValid());
        Assert.assertEquals((long)1L, (long)flag.intValue());
        Assert.assertFalse((boolean)editors.isValid());
        Assert.assertEquals((long)2L, (long)flag.intValue());
        Assert.assertTrue((boolean)editors.isValid());
    }

    private static class SimplePropertyEditor
    extends AbstractPropertyEditor {
        public SimplePropertyEditor(SimpleProperty property1) {
            super((Property)property1);
        }

        public Component getComponent() {
            return null;
        }

        public FocusGroup getFocusGroup() {
            return null;
        }
    }

    private static class CountingListener
    implements ModifiableListener {
        private int count;

        private CountingListener() {
        }

        public int getCount() {
            return this.count;
        }

        public void modified(Modifiable modifiable) {
            ++this.count;
        }
    }
}

