/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.app;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextHelper;
import org.openvpms.web.component.app.LocalContext;
import org.springframework.beans.factory.annotation.Autowired;

public class ContextHelperTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;

    @Test
    public void testSetCustomer() {
        Party customer1 = this.customerFactory.createCustomer();
        Party patientA = this.patientFactory.createPatient(customer1);
        Party patientB = this.patientFactory.createPatient(customer1);
        Party customer2 = this.customerFactory.createCustomer();
        LocalContext context = new LocalContext();
        context.setCustomer(customer1);
        context.setPatient(patientA);
        Assert.assertEquals((Object)customer1, (Object)context.getCustomer());
        Assert.assertEquals((Object)patientA, (Object)context.getPatient());
        context.setPatient(patientB);
        ContextHelper.setCustomer((Context)context, (Party)customer1);
        Assert.assertEquals((Object)customer1, (Object)context.getCustomer());
        Assert.assertEquals((Object)patientB, (Object)context.getPatient());
        ContextHelper.setCustomer((Context)context, (Party)customer2);
        Assert.assertEquals((Object)customer2, (Object)context.getCustomer());
        Assert.assertNull((Object)context.getPatient());
    }

    @Test
    public void testSetPatient() {
        Party customer1 = this.customerFactory.createCustomer();
        Party patient1 = this.patientFactory.createPatient(customer1);
        Party customer2 = this.customerFactory.createCustomer();
        Party patient2 = this.patientFactory.createPatient(customer2);
        Party patient3 = this.patientFactory.createPatient();
        LocalContext context = new LocalContext();
        context.setCustomer(customer1);
        context.setPatient(patient1);
        Assert.assertEquals((Object)customer1, (Object)context.getCustomer());
        Assert.assertEquals((Object)patient1, (Object)context.getPatient());
        ContextHelper.setPatient((Context)context, (Party)patient2);
        Assert.assertEquals((Object)customer1, (Object)context.getCustomer());
        Assert.assertNull((Object)context.getPatient());
        ContextHelper.setPatient((Context)context, (Party)patient3);
        Assert.assertEquals((Object)customer1, (Object)context.getCustomer());
        Assert.assertNull((Object)context.getPatient());
        context.setCustomer(customer1);
        context.setPatient(patient1);
        ContextHelper.setPatient((Context)context, null);
        Assert.assertEquals((Object)customer1, (Object)context.getCustomer());
        Assert.assertNull((Object)context.getPatient());
    }

    @Test
    public void testSetPatientWithoutPreservingCurrentCustomer() {
        Party customer1 = this.customerFactory.createCustomer();
        Party patient1 = this.patientFactory.createPatient(customer1);
        Party customer2 = this.customerFactory.createCustomer();
        Party patient2 = this.patientFactory.createPatient(customer2);
        Party patient3 = this.patientFactory.createPatient();
        LocalContext context = new LocalContext();
        context.setCustomer(customer1);
        context.setPatient(patient1);
        Assert.assertEquals((Object)customer1, (Object)context.getCustomer());
        Assert.assertEquals((Object)patient1, (Object)context.getPatient());
        ContextHelper.setPatient((Context)context, (Party)patient2, (boolean)false);
        Assert.assertEquals((Object)customer2, (Object)context.getCustomer());
        Assert.assertEquals((Object)patient2, (Object)context.getPatient());
        ContextHelper.setPatient((Context)context, (Party)patient3, (boolean)false);
        Assert.assertNull((Object)context.getCustomer());
        Assert.assertEquals((Object)patient3, (Object)context.getPatient());
        ContextHelper.setPatient((Context)context, (Party)patient1, (boolean)false);
        Assert.assertEquals((Object)customer1, (Object)context.getCustomer());
        Assert.assertEquals((Object)patient1, (Object)context.getPatient());
    }
}

