/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.alert;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.prefs.PreferenceService;
import org.openvpms.archetype.rules.prefs.PreferenceServiceImpl;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientAlertTypeBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.alert.AlertManager;
import org.openvpms.web.component.alert.Alerts;
import org.openvpms.web.component.prefs.UserPreferences;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class AlertManagerTestCase
extends ArchetypeServiceTest {
    @Autowired
    private CustomerRules customerRules;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private PracticeRules practiceRules;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestUserFactory userFactory;
    private UserPreferences preferences;

    @Before
    public void setUp() {
        PreferenceServiceImpl preferenceService = new PreferenceServiceImpl(this.getArchetypeService(), this.transactionManager);
        User user = this.userFactory.createUser();
        PracticeService practiceService = new PracticeService(this.getArchetypeService(), this.practiceRules, null);
        this.preferences = new UserPreferences((PreferenceService)preferenceService, practiceService);
        this.preferences.initialise(user);
    }

    @Test
    public void testCustomerAlerts() {
        AlertManager manager1 = this.createAlertManager();
        Lookup alertType1 = this.createCustomerAlertType("VIP", true);
        Lookup alertType2 = this.createCustomerAlertType("NOTE", false);
        Lookup alertType3 = this.createCustomerAlertType("ACCOUNT", true);
        Lookup accountType = this.createCustomerAccountType("BAD_DEBT", alertType3);
        Party customer = this.customerFactory.createCustomer();
        Assert.assertEquals((long)0L, (long)manager1.getAlerts(customer).size());
        Assert.assertEquals((long)0L, (long)manager1.getMandatoryAlerts(customer).size());
        customer.addClassification(accountType);
        this.save((IMObject)customer);
        Act act1 = this.createCustomerAlert(customer, "VIP");
        Act act2 = this.createCustomerAlert(customer, "NOTE");
        List alerts = manager1.getAlerts(customer);
        Assert.assertEquals((long)3L, (long)alerts.size());
        Alert alert1 = this.checkAlert(alerts, act1, (IMObject)alertType1, true);
        Alert alert2 = this.checkAlert(alerts, act2, (IMObject)alertType2, false);
        Alert alert3 = this.checkAlert(alerts, null, (IMObject)alertType3, true);
        List mandatoryAlerts = manager1.getMandatoryAlerts(customer);
        Assert.assertEquals((long)2L, (long)mandatoryAlerts.size());
        this.checkAlert(mandatoryAlerts, act1, (IMObject)alertType1, true);
        this.checkAlert(mandatoryAlerts, null, (IMObject)alertType3, true);
        Assert.assertFalse((boolean)manager1.isAcknowledged(alert1));
        Assert.assertFalse((boolean)manager1.isAcknowledged(alert2));
        Assert.assertFalse((boolean)manager1.isAcknowledged(alert3));
        manager1.acknowledge(alert1);
        Assert.assertTrue((boolean)manager1.isAcknowledged(alert1));
        manager1.acknowledge(alert2);
        Assert.assertFalse((boolean)manager1.isAcknowledged(alert2));
        manager1.acknowledge(alert3);
        Assert.assertTrue((boolean)manager1.isAcknowledged(alert3));
        Assert.assertEquals((long)3L, (long)manager1.getAlerts(customer).size());
        Assert.assertEquals((long)0L, (long)manager1.getMandatoryAlerts(customer).size());
        long nowMinutes = Alerts.nowMinutes();
        this.preferences.setPreference("entity.preferenceGroupGeneral", "customerAlerts", (Object)(act1.getId() + "," + nowMinutes));
        AlertManager manager2 = this.createAlertManager();
        Assert.assertFalse((boolean)manager2.isAcknowledged(alert1));
        Assert.assertTrue((boolean)manager2.isAcknowledged(alert3));
    }

    @Test
    public void testDeactivateCustomerAlertType() {
        AlertManager manager = this.createAlertManager();
        Lookup alertType1 = this.createCustomerAlertType("NOTE", true);
        Lookup alertType2 = this.createCustomerAlertType("ACCOUNT", true);
        Lookup accountType = this.createCustomerAccountType("BAD_DEBT", alertType2);
        Party customer = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addClassifications(new Lookup[]{accountType})).build();
        Act act1 = this.createCustomerAlert(customer, "NOTE");
        List alerts = manager.getAlerts(customer);
        Assert.assertEquals((long)2L, (long)alerts.size());
        this.checkAlert(alerts, act1, (IMObject)alertType1, true);
        this.checkAlert(alerts, null, (IMObject)alertType2, true);
        alertType1.setActive(false);
        alertType2.setActive(false);
        this.save((IMObject[])new Lookup[]{alertType1, alertType2});
        Assert.assertEquals((long)0L, (long)manager.getAlerts(customer).size());
    }

    @Test
    public void testPatientAlerts() {
        AlertManager manager1 = this.createAlertManager();
        Entity alertType1 = this.createPatientAlertType("Allergy", true);
        Entity alertType2 = this.createPatientAlertType("Note", false);
        Party patient = this.patientFactory.createPatient();
        Assert.assertEquals((long)0L, (long)manager1.getAlerts(patient).size());
        Assert.assertEquals((long)0L, (long)manager1.getMandatoryAlerts(patient).size());
        Act act1 = this.patientFactory.createAlert(patient, alertType1);
        Act act2 = this.patientFactory.createAlert(patient, alertType2);
        List alerts = manager1.getAlerts(patient);
        Assert.assertEquals((long)2L, (long)alerts.size());
        Alert alert1 = this.checkAlert(alerts, act1, (IMObject)alertType1, true);
        Alert alert2 = this.checkAlert(alerts, act2, (IMObject)alertType2, false);
        List mandatoryAlerts = manager1.getMandatoryAlerts(patient);
        Assert.assertEquals((long)1L, (long)mandatoryAlerts.size());
        this.checkAlert(mandatoryAlerts, act1, (IMObject)alertType1, true);
        Assert.assertFalse((boolean)manager1.isAcknowledged(alert1));
        Assert.assertFalse((boolean)manager1.isAcknowledged(alert2));
        manager1.acknowledge(alert1);
        Assert.assertTrue((boolean)manager1.isAcknowledged(alert1));
        manager1.acknowledge(alert2);
        Assert.assertFalse((boolean)manager1.isAcknowledged(alert2));
        Assert.assertEquals((long)2L, (long)manager1.getAlerts(patient).size());
        Assert.assertEquals((long)0L, (long)manager1.getMandatoryAlerts(patient).size());
        long nowMinutes = Alerts.nowMinutes();
        this.preferences.setPreference("entity.preferenceGroupGeneral", "patientAlerts", (Object)(act1.getId() + "," + nowMinutes));
        AlertManager manager2 = this.createAlertManager();
        Assert.assertFalse((boolean)manager2.isAcknowledged(alert1));
    }

    @Test
    public void testDeactivatePatientAlertType() {
        AlertManager manager = this.createAlertManager();
        Entity alertType1 = this.createPatientAlertType("Allergy", false);
        Entity alertType2 = this.createPatientAlertType("Aggression", true);
        Party patient = this.patientFactory.createPatient();
        Assert.assertEquals((long)0L, (long)manager.getAlerts(patient).size());
        Act act1 = this.patientFactory.createAlert(patient, alertType1);
        Act act2 = this.patientFactory.createAlert(patient, alertType2);
        List alerts = manager.getAlerts(patient);
        Assert.assertEquals((long)2L, (long)alerts.size());
        this.checkAlert(alerts, act1, (IMObject)alertType1, false);
        this.checkAlert(alerts, act2, (IMObject)alertType2, true);
        alertType2.setActive(false);
        this.save((IMObject)alertType2);
        List alerts2 = manager.getAlerts(patient);
        Assert.assertEquals((long)1L, (long)alerts2.size());
        this.checkAlert(alerts, act1, (IMObject)alertType1, false);
    }

    protected AlertManager createAlertManager() {
        return new AlertManager(this.preferences, this.getLookupService(), this.customerRules, (ArchetypeService)this.getArchetypeService());
    }

    private Entity createPatientAlertType(String name, boolean mandatory) {
        return (Entity)((TestPatientAlertTypeBuilder)this.patientFactory.newAlertType().name(name)).mandatory(mandatory).build();
    }

    private Lookup createCustomerAccountType(String code, Lookup alertType) {
        IMObjectBean bean = this.getBean((IMObject)this.lookupFactory.getLookup("lookup.customerAccountType", code));
        bean.setTarget("alert", (IMObject)alertType);
        bean.save();
        return (Lookup)bean.getObject();
    }

    private Alert checkAlert(List<Alert> alerts, Act act, IMObject alertType, boolean mandatory) {
        Alert alert = this.getAlert(alerts, alertType);
        Assert.assertNotNull((Object)alert);
        Assert.assertEquals((Object)act, (Object)alert.getAlert());
        Assert.assertEquals((Object)alert.isMandatory(), (Object)mandatory);
        return alert;
    }

    private Alert getAlert(List<Alert> alerts, IMObject alertType) {
        return alerts.stream().filter(alert -> alert.getAlertType().equals(alertType)).findFirst().orElse(null);
    }

    private Act createCustomerAlert(Party customer, String alertType) {
        IMObjectBean alert = this.getBean(this.create("act.customerAlert"));
        alert.setTarget("customer", (IMObject)customer);
        alert.setValue("alertType", (Object)alertType);
        alert.save();
        return (Act)alert.getObject();
    }

    private Lookup createCustomerAlertType(String code, boolean mandatoryAlert) {
        IMObjectBean alertType = this.getBean((IMObject)this.lookupFactory.getLookup("lookup.customerAlertType", code));
        alertType.setValue("mandatoryAlert", (Object)mandatoryAlert);
        alertType.save();
        return (Lookup)alertType.getObject();
    }
}

