/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.subscription;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.web.component.subscription.SubscriptionHelper;

public class SubscriptionHelperTestCase {
    @Test
    public void testFormatSubscription() {
        Assert.assertEquals((Object)"This is a trial version of OpenVPMS. Please <a href=\"http://www.openvpms.org/subscription-form\">subscribe</a> to comply with licensing requirements.", (Object)SubscriptionHelper.formatSubscription(null, null, null, (Date)new Date()));
        this.check("OpenVPMS subscription for Vets R Us expires on Friday, 1 January 2016", "2016-01-01", "2015-10-01");
        this.check("OpenVPMS subscription for Vets R Us expires on Friday, 1 January 2016", "2016-01-01", "2015-12-10");
        this.check("WARNING: your OpenVPMS subscription expires on Friday, 1 January 2016.\nPlease contact your administrator to renew the subscription.", "2016-01-01", "2015-12-11");
        this.check("WARNING: your OpenVPMS subscription expires on Friday, 1 January 2016.\nPlease contact your administrator to renew the subscription.", "2016-01-01", "2016-01-01");
        this.check("OpenVPMS subscription for Vets R Us expired on Friday, 1 January 2016.\nPlease contact your administrator to renew the subscription.", "2016-01-01", "2016-01-02");
    }

    private void check(String expected, String expiryDate, String now) {
        String organisation = "Vets R Us";
        String name = "A Vet";
        String text = SubscriptionHelper.formatSubscription((String)organisation, (String)name, (Date)TestHelper.getDate((String)expiryDate), (Date)TestHelper.getDate((String)now));
        Assert.assertEquals((Object)expected, (Object)text);
    }
}

