/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyException;
import org.openvpms.web.component.property.PropertyTransformer;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;

public abstract class AbstractPropertyTest
extends ArchetypeServiceTest {
    @Test
    public void testValidation() {
        TestProperty property = this.createTestProperty(1, 10);
        Assert.assertFalse((boolean)property.isValid());
        Assert.assertEquals((long)1L, (long)property.getValidations());
        property.setValue("Foo");
        Assert.assertTrue((boolean)property.isValid());
        Assert.assertEquals((long)2L, (long)property.getValidations());
        Assert.assertTrue((boolean)property.isValid());
        Assert.assertEquals((long)2L, (long)property.getValidations());
        property.setValue(null);
        Assert.assertFalse((boolean)property.isValid());
        Assert.assertEquals((long)3L, (long)property.getValidations());
        Assert.assertFalse((boolean)property.isValid());
        Assert.assertEquals((long)4L, (long)property.getValidations());
        property.setValue("Bar");
        Assert.assertTrue((boolean)property.isValid());
        Assert.assertEquals((long)5L, (long)property.getValidations());
        Assert.assertTrue((boolean)property.isValid());
        Assert.assertEquals((long)5L, (long)property.getValidations());
        property.resetValid();
        Assert.assertTrue((boolean)property.isValid());
        Assert.assertEquals((long)6L, (long)property.getValidations());
        Assert.assertTrue((boolean)property.isValid());
        Assert.assertEquals((long)6L, (long)property.getValidations());
        property.refresh();
        Assert.assertTrue((boolean)property.isValid());
        Assert.assertEquals((long)7L, (long)property.getValidations());
        Assert.assertTrue((boolean)property.isValid());
        Assert.assertEquals((long)7L, (long)property.getValidations());
    }

    @Test
    public void testModified() {
        Property property = this.createStringProperty("Foo");
        Assert.assertFalse((boolean)property.isModified());
        property.setValue((Object)"foo");
        Assert.assertTrue((boolean)property.isModified());
        property.clearModified();
        Assert.assertFalse((boolean)property.isModified());
    }

    @Test
    public void testRefresh() {
        final int[] updates = new int[1];
        Property property = this.createStringProperty("Foo");
        property.addModifiableListener(new ModifiableListener(){

            public void modified(Modifiable modifiable) {
                updates[0] = updates[0] + 1;
            }
        });
        Assert.assertFalse((boolean)property.isModified());
        property.refresh();
        Assert.assertEquals((long)1L, (long)updates[0]);
        Assert.assertTrue((boolean)property.isModified());
        property.refresh();
        Assert.assertEquals((long)2L, (long)updates[0]);
        Assert.assertTrue((boolean)property.isModified());
    }

    @Test
    public void testListener() {
        Property property = this.createStringProperty("Foo");
        CountingListener listener1 = new CountingListener();
        CountingListener listener2 = new CountingListener();
        property.addModifiableListener((ModifiableListener)listener1);
        property.addModifiableListener((ModifiableListener)listener2);
        property.setValue((Object)"Foo");
        Assert.assertEquals((long)1L, (long)listener1.getCount());
        Assert.assertEquals((long)1L, (long)listener2.getCount());
        property.removeModifiableListener((ModifiableListener)listener2);
        property.setValue((Object)"Bar");
        Assert.assertEquals((long)2L, (long)listener1.getCount());
        Assert.assertEquals((long)1L, (long)listener2.getCount());
        property.setValue((Object)"Bar");
        Assert.assertEquals((long)2L, (long)listener1.getCount());
        Assert.assertEquals((long)1L, (long)listener2.getCount());
        property.removeModifiableListener((ModifiableListener)listener1);
        property.setValue((Object)"Foo");
        Assert.assertEquals((long)2L, (long)listener1.getCount());
        Assert.assertEquals((long)1L, (long)listener2.getCount());
    }

    @Test
    public void testRemoveListenerInCallback() {
        final Property property = this.createStringProperty("Foo");
        final ModifiableListener[] container = new ModifiableListener[1];
        CountingListener listener1 = new CountingListener(){

            @Override
            public void modified(Modifiable modifiable) {
                super.modified(modifiable);
                property.removeModifiableListener(container[0]);
            }
        };
        container[0] = listener1;
        CountingListener listener2 = new CountingListener();
        property.addModifiableListener((ModifiableListener)listener1);
        property.addModifiableListener((ModifiableListener)listener2);
        property.setValue((Object)"Bar");
        property.setValue((Object)"Foo");
        Assert.assertEquals((long)1L, (long)listener1.getCount());
        Assert.assertEquals((long)2L, (long)listener2.getCount());
    }

    @Test
    public abstract void testGetDescriptor();

    @Test
    public void testName() {
        Property property = this.createStringProperty("foo");
        Assert.assertEquals((Object)"foo", (Object)property.getName());
    }

    @Test
    public abstract void testDisplayName();

    @Test
    public abstract void testDescription();

    public void testGetMinLength() {
        Property property = this.createStringProperty("foo", 2, 25);
        Assert.assertEquals((long)2L, (long)property.getMinLength());
    }

    public void testGetMaxLength() {
        Property property = this.createStringProperty("foo", 2, 25);
        Assert.assertEquals((long)25L, (long)property.getMaxLength());
    }

    @Test
    public void testIsBoolean() {
        Property property = this.createBooleanProperty("property");
        Assert.assertTrue((boolean)property.isBoolean());
        Assert.assertFalse((boolean)property.isCollection());
        Assert.assertFalse((boolean)property.isDate());
        Assert.assertFalse((boolean)property.isLookup());
        Assert.assertFalse((boolean)property.isMoney());
        Assert.assertFalse((boolean)property.isNumeric());
        Assert.assertFalse((boolean)property.isString());
        Assert.assertFalse((boolean)property.isObjectReference());
        Assert.assertEquals(Boolean.class, (Object)property.getType());
    }

    @Test
    public void testIsString() {
        Property property = this.createStringProperty("property");
        Assert.assertFalse((boolean)property.isBoolean());
        Assert.assertFalse((boolean)property.isCollection());
        Assert.assertFalse((boolean)property.isDate());
        Assert.assertFalse((boolean)property.isLookup());
        Assert.assertFalse((boolean)property.isMoney());
        Assert.assertFalse((boolean)property.isNumeric());
        Assert.assertTrue((boolean)property.isString());
        Assert.assertFalse((boolean)property.isObjectReference());
        Assert.assertEquals(String.class, (Object)property.getType());
    }

    @Test
    public void testIsNumeric() {
        this.checkNumeric(Byte.class);
        this.checkNumeric(Short.class);
        this.checkNumeric(Integer.class);
        this.checkNumeric(Long.class);
        this.checkNumeric(Float.class);
        this.checkNumeric(Double.class);
        this.checkNumeric(BigDecimal.class);
        this.checkNumeric(BigInteger.class);
        this.checkNumeric(Money.class);
    }

    @Test
    public void testIsDate() {
        Property property = this.createProperty("property", Date.class);
        Assert.assertFalse((boolean)property.isBoolean());
        Assert.assertFalse((boolean)property.isCollection());
        Assert.assertTrue((boolean)property.isDate());
        Assert.assertFalse((boolean)property.isLookup());
        Assert.assertFalse((boolean)property.isMoney());
        Assert.assertFalse((boolean)property.isNumeric());
        Assert.assertFalse((boolean)property.isString());
        Assert.assertFalse((boolean)property.isObjectReference());
        Assert.assertEquals(Date.class, (Object)property.getType());
    }

    @Test
    public void testIsMoney() {
        Property property = this.createProperty("property", Money.class);
        Assert.assertFalse((boolean)property.isBoolean());
        Assert.assertFalse((boolean)property.isCollection());
        Assert.assertFalse((boolean)property.isDate());
        Assert.assertFalse((boolean)property.isLookup());
        Assert.assertTrue((boolean)property.isMoney());
        Assert.assertTrue((boolean)property.isNumeric());
        Assert.assertFalse((boolean)property.isString());
        Assert.assertFalse((boolean)property.isObjectReference());
        Assert.assertEquals(Money.class, (Object)property.getType());
    }

    @Test
    public void testIsObjectReference() {
        Property property = this.createProperty("property", IMObjectReference.class);
        Assert.assertFalse((boolean)property.isBoolean());
        Assert.assertFalse((boolean)property.isCollection());
        Assert.assertFalse((boolean)property.isDate());
        Assert.assertFalse((boolean)property.isLookup());
        Assert.assertFalse((boolean)property.isMoney());
        Assert.assertFalse((boolean)property.isNumeric());
        Assert.assertFalse((boolean)property.isString());
        Assert.assertTrue((boolean)property.isObjectReference());
        Assert.assertEquals(IMObjectReference.class, (Object)property.getType());
    }

    @Test
    public abstract void testIsLookup();

    @Test
    public abstract void testIsCollection();

    @Test
    public abstract void testGetArchetypeRange();

    @Test
    public abstract void testIsDerived();

    @Test
    public abstract void testIsReadOnly();

    @Test
    public abstract void testIsHidden();

    @Test
    public abstract void testIsRequired();

    @Test
    public void testMinLengthValidation() {
        Property property = this.createStringProperty("foo", 2, 255);
        property.setValue((Object)"X");
        Assert.assertFalse((boolean)property.isValid());
        String error = Messages.format((String)"property.error.minLength", (Object[])new Object[]{property.getMinLength()});
        this.checkValidationError(property, error);
        property.setValue((Object)"XX");
        Assert.assertTrue((boolean)property.isValid());
    }

    @Test
    public void testMaxLengthValidation() {
        Property property = this.createStringProperty("foo", 0, 30);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < property.getMaxLength() + 1; ++i) {
            builder.append("x");
        }
        property.setValue((Object)builder.toString());
        Assert.assertFalse((boolean)property.isValid());
        this.checkValidationError(property, Messages.format((String)"property.error.maxLength", (Object[])new Object[]{property.getMaxLength()}));
        property.setValue((Object)"X");
        Assert.assertTrue((boolean)property.isValid());
    }

    @Test
    public void testPropertyTransformerValidation() {
        final Property property = this.createStringProperty("foo");
        property.setValue((Object)"Foo");
        Assert.assertTrue((boolean)property.isValid());
        property.setTransformer(new PropertyTransformer(){

            public Object apply(Object object) {
                throw new PropertyException(property, "Invalid");
            }
        });
        property.setValue((Object)"Bar");
        this.checkValidationError(property, "Invalid");
    }

    public void testIsEmpty() {
        Property property = this.createStringProperty("foo");
        Assert.assertTrue((boolean)property.isEmpty());
        property.setValue((Object)"");
        Assert.assertTrue((boolean)property.isEmpty());
        property.setValue((Object)"Foo");
        Assert.assertFalse((boolean)property.isEmpty());
    }

    protected void checkValidationError(Property property, String message) {
        DefaultValidator validator = new DefaultValidator();
        Assert.assertFalse((boolean)validator.validate((Modifiable)property));
        List list = validator.getErrors((Modifiable)property);
        Assert.assertEquals((long)1L, (long)list.size());
        ValidatorError error = (ValidatorError)list.get(0);
        Assert.assertEquals((Object)message, (Object)error.toString());
    }

    protected abstract Property createBooleanProperty(String var1);

    protected Property createStringProperty(String name) {
        return this.createStringProperty(name, 0, 255);
    }

    protected abstract Property createStringProperty(String var1, int var2, int var3);

    protected abstract Property createProperty(String var1, Class var2);

    protected abstract TestProperty createTestProperty(int var1, int var2);

    private void checkNumeric(Class type) {
        Property property = this.createProperty("property", type);
        Assert.assertFalse((boolean)property.isBoolean());
        Assert.assertFalse((boolean)property.isCollection());
        Assert.assertFalse((boolean)property.isDate());
        Assert.assertFalse((boolean)property.isLookup());
        Assert.assertTrue((boolean)property.isNumeric());
        Assert.assertFalse((boolean)property.isString());
        Assert.assertEquals((Object)type, (Object)property.getType());
    }

    protected static class CountingListener
    implements ModifiableListener {
        private int count;

        protected CountingListener() {
        }

        public void modified(Modifiable modifiable) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    protected static interface TestProperty
    extends Property {
        public int getValidations();
    }
}

