/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.prefs;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.math.Currencies;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.prefs.PreferenceService;
import org.openvpms.archetype.rules.prefs.PreferenceServiceImpl;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.prefs.UserPreferences;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class UserPreferencesTestCase
extends ArchetypeServiceTest {
    @Autowired
    PlatformTransactionManager transactionManager;

    @Test
    public void testInheritPracticeDefaults() {
        User user = TestHelper.createUser();
        PreferenceServiceImpl preferenceService = new PreferenceServiceImpl(this.getArchetypeService(), this.transactionManager);
        Preferences defaultPrefs = preferenceService.getPreferences(TestHelper.getPractice(), null, true);
        defaultPrefs.setPreference("entity.preferenceGroupGeneral", "homePage", (Object)"workflow.scheduling");
        defaultPrefs.setPreference("entity.preferenceGroupSummary", "showReferral", (Object)"ACTIVE");
        PracticeRules rules = new PracticeRules((ArchetypeService)this.getArchetypeService(), (Currencies)this.applicationContext.getBean(Currencies.class));
        PracticeService practiceService = new PracticeService(this.getArchetypeService(), rules, null);
        UserPreferences userPreferences = new UserPreferences((PreferenceService)preferenceService, practiceService);
        userPreferences.initialise(user);
        Assert.assertEquals((Object)"workflow.scheduling", (Object)userPreferences.getPreference("entity.preferenceGroupGeneral", "homePage", (Object)"foo"));
        Assert.assertEquals((Object)"ACTIVE", (Object)userPreferences.getString("entity.preferenceGroupSummary", "showReferral", "foo"));
        userPreferences.setPreference("entity.preferenceGroupGeneral", "homePage", (Object)"customer.information");
        userPreferences.setPreference("entity.preferenceGroupSummary", "showReferral", (Object)"NEVER");
        Assert.assertEquals((Object)"customer.information", (Object)userPreferences.getPreference("entity.preferenceGroupGeneral", "homePage", (Object)"foo"));
        Assert.assertEquals((Object)"NEVER", (Object)userPreferences.getString("entity.preferenceGroupSummary", "showReferral", "foo"));
        Assert.assertEquals((Object)"workflow.scheduling", (Object)defaultPrefs.getPreference("entity.preferenceGroupGeneral", "homePage", (Object)"foo"));
        Assert.assertEquals((Object)"ACTIVE", (Object)defaultPrefs.getPreference("entity.preferenceGroupSummary", "showReferral", (Object)"foo"));
    }
}

