/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ListQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.mail.AddressFormatter;
import org.openvpms.web.component.mail.MultiContactSelector;
import org.openvpms.web.component.mail.ToAddressFormatter;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.test.AbstractAppTest;

public class MultiContactSelectorTestCase
extends AbstractAppTest {
    private MultiContactSelector selector;

    @Override
    public void setUp() {
        super.setUp();
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        this.selector = new MultiContactSelector((AddressFormatter)new ToAddressFormatter(), (LayoutContext)context);
    }

    @Test
    public void testAddresses() {
        Assert.assertEquals((Object)DescriptorHelper.getDisplayName((String)"contact.email", (ArchetypeService)this.getArchetypeService()), (Object)this.selector.getType());
        Assert.assertTrue((boolean)this.selector.isValid());
        Assert.assertTrue((boolean)this.selector.getObjects().isEmpty());
        Assert.assertEquals((Object)"", (Object)this.selector.getText());
        TextField field = this.selector.getTextField();
        field.setText("foo@bar.com");
        Assert.assertTrue((boolean)this.selector.isValid());
        List objects = this.selector.getObjects();
        Assert.assertEquals((long)1L, (long)objects.size());
        this.checkEmail((Contact)objects.get(0), "Email Address", "foo@bar.com");
        field.setText("foo@bar.com; jsmith@gmail.com");
        Assert.assertTrue((boolean)this.selector.isValid());
        objects = this.selector.getObjects();
        Assert.assertEquals((long)2L, (long)objects.size());
        this.checkEmail((Contact)objects.get(0), "Email Address", "foo@bar.com");
        this.checkEmail((Contact)objects.get(1), "Email Address", "jsmith@gmail.com");
    }

    @Test
    public void testNamedAddresses() {
        TextField field = this.selector.getTextField();
        field.setText("Foo Bar <foo@bar.com>");
        Assert.assertTrue((boolean)this.selector.isValid());
        List objects = this.selector.getObjects();
        Assert.assertEquals((long)1L, (long)objects.size());
        this.checkEmail((Contact)objects.get(0), "Foo Bar", "foo@bar.com");
        field.setText("Foo Bar <foo@bar.com>; J Smith <jsmith@gmail.com>");
        Assert.assertTrue((boolean)this.selector.isValid());
        objects = this.selector.getObjects();
        Assert.assertEquals((long)2L, (long)objects.size());
        this.checkEmail((Contact)objects.get(0), "Foo Bar", "foo@bar.com");
        this.checkEmail((Contact)objects.get(1), "J Smith", "jsmith@gmail.com");
    }

    @Test
    public void testQuery() {
        Party customer1 = TestHelper.createCustomer((String)"Foo", (String)"Bar", (boolean)false);
        final Contact contact1 = TestHelper.createEmailContact((String)"foo@bar.com");
        customer1.addContact(contact1);
        Party customer2 = TestHelper.createCustomer((String)"J", (String)"Smith", (boolean)false);
        final Contact contact2 = TestHelper.createEmailContact((String)"jsmith@gmail.com");
        contact2.setName("J Smith");
        customer2.addContact(contact2);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        this.selector = new MultiContactSelector((AddressFormatter)new ToAddressFormatter(), (LayoutContext)context){

            protected Query<Contact> createQuery(String value) {
                ArrayList<Contact> contacts = new ArrayList<Contact>();
                if ("Foo Bar".equals(value)) {
                    contacts.add(contact1);
                } else if ("J Smith".equals(value)) {
                    contacts.add(contact2);
                }
                return new ListQuery(contacts, "contact.email", false, Contact.class);
            }
        };
        TextField field = this.selector.getTextField();
        field.setText("Foo Bar");
        field.processInput("action", null);
        Assert.assertTrue((boolean)this.selector.isValid());
        Assert.assertEquals((Object)"foo@bar.com; ", (Object)field.getText());
        List objects = this.selector.getObjects();
        Assert.assertEquals((long)1L, (long)objects.size());
        this.checkEmail((Contact)objects.get(0), "Email Address", "foo@bar.com");
        field.setText("Foo Bar; J Smith");
        field.processInput("action", null);
        Assert.assertTrue((boolean)this.selector.isValid());
        Assert.assertEquals((Object)"foo@bar.com; J Smith <jsmith@gmail.com>; ", (Object)field.getText());
        objects = this.selector.getObjects();
        Assert.assertEquals((long)2L, (long)objects.size());
        this.checkEmail((Contact)objects.get(0), "Email Address", "foo@bar.com");
        this.checkEmail((Contact)objects.get(1), "J Smith", "jsmith@gmail.com");
    }

    private void checkEmail(Contact contact, String name, String email) {
        Assert.assertNotNull((Object)contact);
        Assert.assertEquals((Object)name, (Object)contact.getName());
        IMObjectBean bean = this.getBean((IMObject)contact);
        Assert.assertEquals((Object)email, (Object)bean.getString("emailAddress"));
    }
}

